/*
 * Decompiled with CFR 0.152.
 */
package org.mikha.utils.web.jsp;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.JspFragment;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.mikha.utils.Escape;
import org.mikha.utils.net.UrlAndParams;
import org.mikha.utils.web.jsp.ParametrizedTag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormTag
extends SimpleTagSupport
implements ParametrizedTag {
    private Object tagUrl = null;
    private String method = "post";
    private String id = null;
    private String cls = null;
    private String style = null;
    private Map<String, Object> tagParams = new LinkedHashMap<String, Object>();

    public void setUrl(Object value) {
        this.tagUrl = value;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setId(String formId) {
        this.id = formId;
    }

    public void setClass(String formClass) {
        this.cls = formClass;
    }

    public void setStyle(String formStyle) {
        this.style = formStyle;
    }

    @Override
    public void setParamValue(String name, Object value) {
        this.tagParams.put(name, value);
    }

    public void doTag() throws JspException, IOException {
        Map params;
        String url;
        if (this.tagUrl == null) {
            this.tagUrl = ".";
        }
        if (this.tagUrl instanceof UrlAndParams) {
            UrlAndParams uap = (UrlAndParams)this.tagUrl;
            url = uap.getUrl();
            params = uap.getParams();
        } else {
            url = this.tagUrl.toString();
            params = Collections.EMPTY_MAP;
        }
        JspWriter w = this.getJspContext().getOut();
        w.print("<form ");
        if (url.length() > 0 && url.charAt(0) == '/') {
            HttpServletRequest req = (HttpServletRequest)((PageContext)this.getJspContext()).getRequest();
            url = req.getContextPath() + url;
        }
        this.printAttr(w, "action", Escape.toValidXml((String)url));
        this.printAttr(w, "method", this.method);
        this.printAttr(w, "id", this.id);
        this.printAttr(w, "class", this.cls);
        this.printAttr(w, "style", this.style);
        w.println('>');
        this.printParams(params, w);
        JspFragment body = this.getJspBody();
        if (body != null) {
            body.invoke(null);
        }
        this.printParams(this.tagParams, w);
        w.println("</form>");
    }

    private void printParams(Map<String, Object> params, JspWriter w) throws IOException {
        for (Map.Entry<String, Object> e : params.entrySet()) {
            w.print("<input");
            this.printAttr(w, "type", "hidden");
            this.printAttr(w, "name", Escape.toValidXml((String)e.getKey()));
            this.printAttr(w, "value", Escape.toValidXml((String)(e.getValue() != null ? e.getValue().toString() : "")));
            w.println('>');
        }
    }

    private void printAttr(JspWriter w, String attr, String value) throws IOException {
        if (value == null) {
            return;
        }
        w.print(' ');
        w.print(attr);
        w.print('=');
        w.print('\"');
        w.print(value);
        w.print('\"');
    }
}

