/*
 * Decompiled with CFR 0.152.
 */
package org.mikha.utils.web.log4j;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.mikha.utils.log4j.InMemoryAppender;
import org.mikha.utils.web.BaseControllerServlet;
import org.mikha.utils.web.ControllerMethodMapping;
import org.mikha.utils.web.HttpParamsRequest;

public class Log4jServlet
extends BaseControllerServlet {
    private static final Logger LOGGER = Logger.getLogger(Log4jServlet.class);
    private static final Pattern LEVELS_PATTERN = Pattern.compile("^(.*)=(.*)$", 8);
    private InMemoryAppender inMemoryAppender = null;

    public void init() throws ServletException {
        LOGGER.debug((Object)"enter init()");
        super.init();
        Logger root = Logger.getRootLogger();
        Enumeration ea = root.getAllAppenders();
        while (ea.hasMoreElements()) {
            Appender a = (Appender)ea.nextElement();
            if (!(a instanceof InMemoryAppender)) continue;
            this.inMemoryAppender = (InMemoryAppender)a;
        }
        if (this.inMemoryAppender == null) {
            throw new ServletException("InMemoryAppender is not configured for root logger");
        }
        LOGGER.debug((Object)"leave init()");
    }

    @ControllerMethodMapping(paths={"/view"})
    public void view(HttpParamsRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug((Object)"enter view()");
        this.streamEvents(response, false);
        LOGGER.debug((Object)"leave view()");
    }

    @ControllerMethodMapping(paths={"/download"})
    public void download(HttpParamsRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug((Object)"enter download()");
        this.streamEvents(response, true);
        LOGGER.debug((Object)"leave download()");
    }

    @ControllerMethodMapping(paths={"/config"})
    public String configure(HttpParamsRequest request) throws IOException {
        String logger;
        String levels = request.getParameter("levels");
        if (levels != null) {
            Matcher m = LEVELS_PATTERN.matcher(levels);
            HashSet<String> configuredLoggers = new HashSet<String>();
            while (m.find()) {
                logger = m.group(1);
                String levelz = m.group(2);
                LOGGER.debug((Object)(logger + '=' + levelz));
                Level level = Level.toLevel((String)levelz, null);
                if (level == null) {
                    request.logParameterError("levels", "Invalid level value " + levelz);
                    continue;
                }
                if (logger.equals("root")) {
                    Logger.getRootLogger().setLevel(level);
                } else {
                    Logger.getLogger((String)logger).setLevel(level);
                }
                LOGGER.info((Object)("Changed log level for logger " + logger + " to " + level));
                configuredLoggers.add(logger);
            }
            Enumeration loggers = LogManager.getCurrentLoggers();
            while (loggers.hasMoreElements()) {
                Logger logger2 = (Logger)loggers.nextElement();
                if (logger2.getLevel() == null || configuredLoggers.contains(logger2.getName())) continue;
                logger2.setLevel(null);
                LOGGER.info((Object)("Removed log level for logger " + logger2.getName()));
            }
        }
        StringBuffer currentConfig = new StringBuffer();
        currentConfig.append("root=").append(Logger.getRootLogger().getLevel()).append('\n');
        Enumeration loggers = LogManager.getCurrentLoggers();
        while (loggers.hasMoreElements()) {
            logger = (Logger)loggers.nextElement();
            Level level = logger.getLevel();
            if (level == null) continue;
            currentConfig.append(logger.getName()).append('=').append(level).append('\n');
        }
        request.setAttribute("levels", currentConfig.toString());
        return "logging.jsp";
    }

    private void streamEvents(HttpServletResponse response, boolean isDownload) throws IOException {
        Iterator iterator;
        response.setContentType("text/plain");
        if (isDownload) {
            response.setHeader("Content-Disposition", "attachment; filename=" + this.getServletContext().getServletContextName() + ".log");
            iterator = this.inMemoryAppender.iterator(false);
        } else {
            iterator = this.inMemoryAppender.iterator(true);
        }
        Layout layout = this.inMemoryAppender.getLayout();
        PrintWriter w = response.getWriter();
        while (!w.checkError() && iterator.hasNext()) {
            LoggingEvent e = (LoggingEvent)iterator.next();
            if (e != null) {
                w.print(layout.format(e));
            }
            if (isDownload) continue;
            w.flush();
        }
        w.close();
    }
}

