/*
 * Decompiled with CFR 0.152.
 */
package org.mikha.utils.web.multipart;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.mikha.utils.web.multipart.MultipartRequestWrapper;

public class MultiparFilter
implements Filter {
    private FileItemFactory fileItemFactory;

    public void init(FilterConfig config) throws ServletException {
        File dir;
        String s = config.getInitParameter("uploadDir");
        if (s != null) {
            dir = new File(s);
        } else {
            dir = (File)config.getServletContext().getAttribute("javax.servlet.context.tempdir");
            if (dir == null) {
                throw new ServletException("Cannot determine temporary upload directory. Set an uploadDir init parameter or ensure the javax.servlet.context.tempdir directory is valid");
            }
        }
        int maxSize = Integer.MAX_VALUE;
        s = config.getInitParameter("maxSize");
        if (s != null) {
            try {
                maxSize = Integer.parseInt(s);
                if (maxSize <= 0) {
                    throw new IllegalArgumentException("Must be positive");
                }
            }
            catch (IllegalArgumentException iaex) {
                throw new ServletException("Value \"" + s + "\" is not valid for maxSize parameter", (Throwable)iaex);
            }
        }
        this.fileItemFactory = new DiskFileItemFactory(maxSize, dir);
    }

    public void doFilter(ServletRequest req, ServletResponse rsp, FilterChain chain) throws IOException, ServletException {
        if (!(req instanceof HttpServletRequest)) {
            chain.doFilter(req, rsp);
            return;
        }
        HttpServletRequest hreq = (HttpServletRequest)req;
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)hreq)) {
            chain.doFilter(req, rsp);
            return;
        }
        try {
            HashMap<String, LinkedList<String>> tmp = new HashMap<String, LinkedList<String>>();
            HashMap<String, FileItem> files = new HashMap<String, FileItem>();
            ServletFileUpload upload = new ServletFileUpload(this.fileItemFactory);
            for (FileItem item : upload.parseRequest(hreq)) {
                String name = item.getFieldName();
                if (item.isFormField()) {
                    LinkedList<String> list = (LinkedList<String>)tmp.get(name);
                    if (list == null) {
                        list = new LinkedList<String>();
                        tmp.put(name, list);
                    }
                    list.add(item.getString());
                    continue;
                }
                files.put(name, item);
            }
            HashMap<String, String[]> params = new HashMap<String, String[]>(tmp.size());
            for (Map.Entry me : tmp.entrySet()) {
                List l = (List)me.getValue();
                params.put((String)me.getKey(), l.toArray(new String[l.size()]));
            }
            chain.doFilter((ServletRequest)new MultipartRequestWrapper(hreq, params, files), rsp);
        }
        catch (FileUploadException fuex) {
            throw new ServletException("Failed to process uploaded file", (Throwable)fuex);
        }
    }

    public void destroy() {
    }
}

