/*
 * Decompiled with CFR 0.152.
 */
package org.mikha.utils.web.multipart;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.fileupload.FileItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipartRequestWrapper
extends HttpServletRequestWrapper {
    private static final String ATTR_FILES = "_multipart_files";
    private final Map<String, String[]> params;

    public static Map<String, FileItem> getFilesMap(HttpServletRequest req) {
        HashMap files = (HashMap)req.getAttribute(ATTR_FILES);
        if (files == null) {
            files = new HashMap();
            req.setAttribute(ATTR_FILES, files);
        }
        return files;
    }

    public static FileItem getFile(HttpServletRequest req, String name) {
        return MultipartRequestWrapper.getFilesMap(req).get(name);
    }

    public MultipartRequestWrapper(HttpServletRequest request, Map<String, String[]> params, Map<String, FileItem> files) {
        super(request);
        this.params = params;
        request.setAttribute(ATTR_FILES, files);
    }

    public Map<String, String[]> getParameterMap() {
        return this.params;
    }

    public String getParameter(String name) {
        String[] v = this.params.get(name);
        if (v == null) {
            return null;
        }
        return v[0];
    }

    public Enumeration<String> getParameterNames() {
        Vector<String> v = new Vector<String>(this.params.keySet());
        return v.elements();
    }

    public String[] getParameterValues(String name) {
        return this.params.get(name);
    }
}

