/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.migration;

import it.openutils.migration.DbSetupManager;
import it.openutils.migration.DbVersionManager;
import it.openutils.migration.task.setup.DbTask;
import it.openutils.migration.task.update.DbUpdate;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbSetupManagerImpl
implements DbSetupManager {
    private static Logger log = LoggerFactory.getLogger(DbSetupManagerImpl.class);
    private List<DbTask> setupTasks;
    private List<DbUpdate> updateTasks;
    private DataSource dataSource;
    private DbVersionManager versionManager;
    private TransactionTemplate transactionTemplate;
    private boolean enabled = true;
    private String name;

    public void setName(String name) {
        this.name = name;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setVersionManager(DbVersionManager versionManager) {
        this.versionManager = versionManager;
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = transactionTemplate;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setSetupTasks(List<DbTask> setupTasks) {
        this.setupTasks = setupTasks;
    }

    public void setUpdateTasks(List<DbUpdate> updateTasks) {
        this.updateTasks = updateTasks;
    }

    @Override
    public void updateDDL() {
        if (!this.enabled) {
            log.info("DB migration is disabled, not running tasks.");
            return;
        }
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                if (DbSetupManagerImpl.this.setupTasks != null) {
                    DbSetupManagerImpl.this.executeSetupTasks();
                }
                if (DbSetupManagerImpl.this.updateTasks != null) {
                    DbSetupManagerImpl.this.executeUpdateTasks();
                }
            }
        });
    }

    private void executeSetupTasks() {
        log.info("Preparing {}, checking {} setup tasks.", (Object)StringUtils.defaultIfEmpty((String)this.name, (String)"db"), (Object)this.setupTasks.size());
        for (DbTask task : this.setupTasks) {
            log.debug(task.getDescription());
            task.execute(this.dataSource);
        }
    }

    private void executeUpdateTasks() {
        int initialVersion;
        int currentVersion = initialVersion = this.versionManager.getCurrentVersion();
        TreeSet<DbUpdate> sortedMigrations = new TreeSet<DbUpdate>(new Comparator<DbUpdate>(){

            @Override
            public int compare(DbUpdate o1, DbUpdate o2) {
                return o1.getVersion() - o2.getVersion();
            }
        });
        sortedMigrations.addAll(this.updateTasks);
        log.info("Found {} migrations, looking for updates to run...", (Object)this.updateTasks.size());
        for (DbUpdate update : sortedMigrations) {
            if (update.getVersion() <= currentVersion) continue;
            currentVersion = update.getVersion();
            log.info("Preparing migration to version {}. {}", (Object)update.getVersion(), (Object)update.getDescription());
            try {
                update.execute(this.dataSource);
            }
            catch (DataAccessException e) {
                log.error("\n***********\n\n\nDatabase upgrade from version " + initialVersion + " to version " + currentVersion + " FAILED!\n\n\n***********\n", (Throwable)e);
            }
            this.versionManager.setNewVersion(currentVersion);
        }
        if (currentVersion != initialVersion) {
            log.info("Database upgraded from version {} to version {}", (Object)initialVersion, (Object)currentVersion);
        } else {
            log.info("No Database upgrade is needed. Current version is {} ", (Object)initialVersion);
        }
    }
}

