/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.migration.generic;

import it.openutils.migration.task.setup.BaseConditionalTask;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JdbcColumnBasedConditionalTask
extends BaseConditionalTask {
    protected String column;
    protected String catalog;
    protected String schema;

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    @Override
    public boolean check(SimpleJdbcTemplate jdbcTemplate) {
        String columnTrim = StringUtils.trim((String)this.column);
        final String tableName = StringUtils.substringBefore((String)columnTrim, (String)".");
        final String columnName = StringUtils.substringAfter((String)columnTrim, (String)".");
        return (Boolean)jdbcTemplate.getJdbcOperations().execute(new ConnectionCallback(){

            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                DatabaseMetaData dbMetadata = con.getMetaData();
                ResultSet rs = dbMetadata.getColumns(JdbcColumnBasedConditionalTask.this.catalog, JdbcColumnBasedConditionalTask.this.schema, tableName, columnName);
                boolean conditionMet = rs.next();
                if (conditionMet) {
                    ResultSetMetaData rsmeta = rs.getMetaData();
                    int colcount = rsmeta.getColumnCount();
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    for (int j = 1; j <= colcount; ++j) {
                        params.put(rsmeta.getColumnName(j), rs.getObject(j));
                    }
                    conditionMet = JdbcColumnBasedConditionalTask.this.checkColumnMetadata(params);
                }
                rs.close();
                return conditionMet;
            }
        });
    }

    protected abstract boolean checkColumnMetadata(Map<String, Object> var1);
}

