/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.migration.generic;

import it.openutils.migration.task.setup.BaseConditionalTask;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class JdbcIfColumnExistsConditionalTask
extends BaseConditionalTask {
    protected String column;
    protected String catalog;
    protected String schema;

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public boolean check(SimpleJdbcTemplate jdbcTemplate) {
        String columnTrim = StringUtils.trim((String)this.column);
        final String tableName = StringUtils.substringBefore((String)columnTrim, (String)".");
        final String columnName = StringUtils.substringAfter((String)columnTrim, (String)".");
        return (Boolean)jdbcTemplate.getJdbcOperations().execute(new ConnectionCallback(){

            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                DatabaseMetaData dbMetadata = con.getMetaData();
                ResultSet rs = dbMetadata.getColumns(JdbcIfColumnExistsConditionalTask.this.catalog, JdbcIfColumnExistsConditionalTask.this.schema, tableName, columnName);
                boolean tableExists = rs.next();
                rs.close();
                return tableExists;
            }
        });
    }
}

