/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.migration.generic;

import it.openutils.migration.task.setup.BaseConditionalTask;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class JdbcIfTableExistsConditionalTask
extends BaseConditionalTask {
    protected String table;
    protected String catalog;
    protected String schema;

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public boolean check(SimpleJdbcTemplate jdbcTemplate) {
        final String tableName = StringUtils.trim((String)this.table);
        return (Boolean)jdbcTemplate.getJdbcOperations().execute(new ConnectionCallback(){

            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                DatabaseMetaData dbMetadata = con.getMetaData();
                ResultSet rs = dbMetadata.getTables(JdbcIfTableExistsConditionalTask.this.catalog, JdbcIfTableExistsConditionalTask.this.schema, tableName, null);
                boolean tableExists = rs.next();
                rs.close();
                return tableExists;
            }
        });
    }
}

