/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.migration.oracle;

import it.openutils.migration.task.setup.GenericConditionalTask;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.support.JdbcUtils;

public class OracleStoredProcedureCallTask
extends GenericConditionalTask {
    protected void executeSingle(SimpleJdbcTemplate jdbcTemplate, final String scriptContent) {
        jdbcTemplate.getJdbcOperations().execute(new ConnectionCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                CallableStatement cs = null;
                try {
                    cs = con.prepareCall("{call " + scriptContent.trim() + "}");
                    cs.execute();
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeStatement(cs);
                    throw throwable;
                }
                JdbcUtils.closeStatement((Statement)cs);
                return null;
            }
        });
    }

    public String getDescription() {
        return "calling stored procedures";
    }
}

