/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.migration.oracle;

import it.openutils.migration.task.setup.DbTask;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleViewCreateOrUpdateTask
implements DbTask {
    private Logger log = LoggerFactory.getLogger(OracleViewCreateOrUpdateTask.class);
    private List<Resource> scripts;
    private String selectUserViewExistence;
    private String selectUserViewDDL;
    private String dropView;

    @Override
    public String getDescription() {
        return "Checking Views";
    }

    public void setScripts(List<Resource> scripts) {
        this.scripts = scripts;
    }

    public void setSelectUserViewExistence(String selectUserViewExistence) {
        this.selectUserViewExistence = selectUserViewExistence;
    }

    public void setSelectUserViewDDL(String selectUserViewDDL) {
        this.selectUserViewDDL = selectUserViewDDL;
    }

    public void setDropView(String dropView) {
        this.dropView = dropView;
    }

    @Override
    public void execute(DataSource dataSource) {
        SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(dataSource);
        for (Resource script : this.scripts) {
            String viewName = this.objectNameFromFileName(script);
            int result = jdbcTemplate.queryForInt(this.selectUserViewExistence, new Object[]{viewName});
            String scriptContent = this.readFully(script);
            if (scriptContent == null) continue;
            if (result == 0) {
                this.log.info("View {} not existing. Creating new view", (Object)viewName);
                this.createView(jdbcTemplate, scriptContent);
                continue;
            }
            String scriptBody = this.extractViewBody(scriptContent);
            if (scriptBody == null) continue;
            String previousDDl = (String)jdbcTemplate.getJdbcOperations().queryForObject(this.selectUserViewDDL, new Object[]{viewName}, String.class);
            if (StringUtils.equals((String)previousDDl.trim(), (String)scriptBody.trim())) continue;
            this.log.info("Previous definition of view {} differs from actual. Dropping and recreating view", new Object[]{viewName});
            jdbcTemplate.update(MessageFormat.format(this.dropView, viewName), new Object[0]);
            this.createView(jdbcTemplate, scriptContent);
        }
    }

    private String extractViewBody(String scriptContent) {
        Pattern pattern = Pattern.compile(".*?\\s+AS\\s+(.*);", 34);
        Matcher matcher = pattern.matcher(scriptContent);
        boolean bodyFound = matcher.find();
        if (bodyFound) {
            return matcher.group(1);
        }
        return null;
    }

    private void createView(SimpleJdbcTemplate jdbcTemplate, String script) {
        String[] ddls;
        for (String ddl : ddls = StringUtils.split((String)script, (String)";")) {
            if (!StringUtils.isNotBlank((String)ddl)) continue;
            this.log.debug("Executing:\n{}", (Object)ddl);
            jdbcTemplate.update(ddl, new Object[0]);
        }
    }

    protected String objectNameFromFileName(Resource script) {
        return StringUtils.substringBeforeLast((String)script.getFilename(), (String)".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFully(Resource script) {
        String scriptContent;
        if (script == null || !script.exists()) {
            this.log.error("Unable to execute db task \"{}\", script \"{}\" not found.", (Object)this.getDescription(), (Object)script);
            return null;
        }
        InputStream is = null;
        try {
            is = script.getInputStream();
            scriptContent = IOUtils.toString((InputStream)is, (String)"UTF8");
        }
        catch (IOException e) {
            this.log.error("Unable to execute db task \"{}\", script \"{}\" can't be read.", (Object)this.getDescription(), (Object)script);
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return scriptContent;
    }
}

