/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.migration.sqlserver;

import it.openutils.migration.task.setup.GenericConditionalTask;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class SqlServerFunctionCreateOrUpdateTask
extends GenericConditionalTask {
    public void execute(DataSource dataSource) {
        String checkQuery = "select count(*) from dbo.sysobjects where id = object_id(?) and xtype in (N'FN', N'IF', N'TF')";
        SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(dataSource);
        for (Resource script : this.scripts) {
            String functionName = this.objectNameFromFileName(script);
            int result = jdbcTemplate.queryForInt(checkQuery, new Object[]{functionName});
            String scriptContent = this.readFully(script);
            if (StringUtils.isBlank((String)(scriptContent = StringUtils.replace((String)scriptContent, (String)"\t", (String)" ")))) continue;
            if (result == 0) {
                this.log.info("Function {} not existing. Creating new function", (Object)functionName);
                this.createFunction(jdbcTemplate, scriptContent);
                continue;
            }
            List previousDDlList = jdbcTemplate.getJdbcOperations().queryForList("exec sp_helptext ?", new Object[]{functionName}, String.class);
            String previousDDl = StringUtils.join((Object[])previousDDlList.toArray(new String[previousDDlList.size()]));
            if (StringUtils.equals((String)previousDDl, (String)scriptContent)) continue;
            this.log.info("Previous definition of function {} differs from actual. Dropping and recreating function", new Object[]{functionName});
            jdbcTemplate.update("DROP FUNCTION [" + functionName + "]", new Object[0]);
            this.createFunction(jdbcTemplate, scriptContent);
        }
    }

    private void createFunction(SimpleJdbcTemplate jdbcTemplate, String script) {
        String[] ddls;
        for (String ddl : ddls = StringUtils.split((String)script, (String)";")) {
            if (!StringUtils.isNotBlank((String)ddl)) continue;
            this.log.debug("Executing:\n{}", (Object)ddl);
            jdbcTemplate.update(ddl, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFully(Resource script) {
        String scriptContent;
        if (script == null || !script.exists()) {
            this.log.error("Unable to execute db task \"{}\", script \"{}\" not found.", (Object)this.getDescription(), (Object)script);
            return null;
        }
        InputStream is = null;
        try {
            is = script.getInputStream();
            scriptContent = IOUtils.toString((InputStream)is, (String)"UTF8");
        }
        catch (IOException e) {
            this.log.error("Unable to execute db task \"{}\", script \"{}\" can't be read.", (Object)this.getDescription(), (Object)script);
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return StringUtils.stripEnd((String)StringUtils.trim((String)this.performSubstitution(scriptContent)), (String)";");
    }
}

