/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.migration.sqlserver;

import it.openutils.migration.task.setup.GenericConditionalTask;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class SqlServerViewCreateOrUpdateTask
extends GenericConditionalTask {
    public void execute(DataSource dataSource) {
        String checkQuery = "select count(*) from dbo.sysobjects where id = object_id(?) and OBJECTPROPERTY(id, N'IsView') = 1";
        SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(dataSource);
        for (Resource script : this.scripts) {
            String viewName = this.objectNameFromFileName(script);
            int result = jdbcTemplate.queryForInt(checkQuery, new Object[]{viewName});
            String scriptContent = this.readFully(script);
            if ((scriptContent = StringUtils.replace((String)scriptContent, (String)"\t", (String)" ")) == null) continue;
            if (result == 0) {
                this.log.info("View {} not existing. Creating new view", (Object)viewName);
                this.createView(jdbcTemplate, scriptContent);
                continue;
            }
            List previousDDlList = jdbcTemplate.getJdbcOperations().queryForList("exec sp_helptext ?", new Object[]{viewName}, String.class);
            String previousDDl = StringUtils.join((Object[])previousDDlList.toArray(new String[previousDDlList.size()]));
            if (StringUtils.equals((String)previousDDl, (String)scriptContent)) continue;
            this.log.info("Previous definition of view {} differs from actual. Dropping and recreating view", new Object[]{viewName});
            jdbcTemplate.update("DROP VIEW [dbo].[" + viewName + "]", new Object[0]);
            this.createView(jdbcTemplate, scriptContent);
        }
    }

    private void createView(SimpleJdbcTemplate jdbcTemplate, String script) {
        String[] ddls;
        for (String ddl : ddls = StringUtils.split((String)script, (String)";")) {
            if (!StringUtils.isNotBlank((String)ddl)) continue;
            this.log.debug("Executing:\n{}", (Object)ddl);
            jdbcTemplate.update(ddl, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFully(Resource script) {
        String scriptContent;
        if (script == null || !script.exists()) {
            this.log.error("Unable to execute db task \"{}\", script \"{}\" not found.", (Object)this.getDescription(), (Object)script);
            return null;
        }
        InputStream is = null;
        try {
            is = script.getInputStream();
            scriptContent = IOUtils.toString((InputStream)is, (String)"UTF8");
        }
        catch (IOException e) {
            this.log.error("Unable to execute db task \"{}\", script \"{}\" can't be read.", (Object)this.getDescription(), (Object)script);
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        return StringUtils.stripEnd((String)StringUtils.trim((String)this.performSubstitution(scriptContent)), (String)";");
    }
}

