/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.migration.task.setup;

import it.openutils.migration.task.setup.BaseDbTask;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseConditionalTask
extends BaseDbTask {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected String ddl;
    protected boolean not;
    protected Map<String, String> variables;
    protected List<Resource> scripts;

    public void setScripts(List<Resource> scripts) {
        this.scripts = scripts;
    }

    public final void setDdl(String ddls) {
        this.ddl = ddls;
    }

    public final void setNot(boolean not) {
        this.not = not;
    }

    @Deprecated
    public final void setDdlScript(Resource ddlScript) {
        this.log.warn("ddlScript is deprecated, please use \"scripts\"");
        if (this.scripts == null) {
            this.scripts = new ArrayList<Resource>(1);
        }
        this.scripts.add(ddlScript);
    }

    public abstract boolean check(SimpleJdbcTemplate var1);

    @Override
    public String getDescription() {
        if (StringUtils.isNotEmpty((String)super.getDescription())) {
            return super.getDescription();
        }
        if (this.scripts != null && !this.scripts.isEmpty()) {
            StringBuffer result = new StringBuffer();
            result.append("Checking :\n");
            for (Resource script : this.scripts) {
                result.append("  - " + this.objectNameFromFileName(script) + "\n");
            }
            return result.toString();
        }
        return this.getClass().getName();
    }

    protected String objectNameFromFileName(Resource script) {
        return StringUtils.substringBeforeLast((String)script.getFilename(), (String)".");
    }

    protected String performSubstitution(String string) {
        if (this.variables == null || this.variables.isEmpty()) {
            return string;
        }
        String stringReplaced = string;
        for (String key : this.variables.keySet()) {
            stringReplaced = StringUtils.replace((String)stringReplaced, (String)("${" + key + "}"), (String)this.variables.get(key));
        }
        return stringReplaced;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(DataSource dataSource) {
        SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(dataSource);
        if (this.check(jdbcTemplate) ^ this.not) {
            this.log.info("Executing Alter Task: {}", (Object)this.getDescription());
            if (StringUtils.isNotBlank((String)this.ddl)) {
                this.executeSingle(jdbcTemplate, this.ddl);
            } else {
                if (this.scripts == null || this.scripts.isEmpty()) {
                    this.log.error("Unable to execute db task \"{}\", no ddl or scripts configured.", (Object)this.getDescription());
                    return;
                }
                for (Resource script : this.scripts) {
                    String scriptContent = this.ddl;
                    InputStream is = null;
                    try {
                        is = script.getInputStream();
                        scriptContent = IOUtils.toString((InputStream)is, (String)"UTF8");
                    }
                    catch (IOException e) {
                        this.log.error("Unable to execute db task \"{}\", script \"{}\" can't be read.", (Object)this.getDescription(), (Object)script);
                        return;
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)is);
                    }
                    this.executeSingle(jdbcTemplate, scriptContent);
                }
            }
        }
    }

    protected void executeSingle(SimpleJdbcTemplate jdbcTemplate, String scriptContent) {
        String[] ddls;
        for (String statement : ddls = StringUtils.split((String)this.performSubstitution(scriptContent), (char)';')) {
            if (!StringUtils.isNotBlank((String)statement)) continue;
            this.log.debug("Executing:\n{}", (Object)statement);
            jdbcTemplate.update(statement, new Object[0]);
        }
    }
}

