/**
 *
 * openutils db migration (http://www.openmindlab.com/lab/products/dbmigration.html)
 * Copyright(C) 2007-2010, Openmind S.r.l. http://www.openmindonline.it
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
package it.openutils.migration.postgres;

import it.openutils.migration.task.setup.GenericConditionalTask;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import javax.sql.DataSource;

import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;


/**
 * This is just a patch to move sequences after inserting values from dbMigration. The real solution should be to have
 * all the database objects generated by dbMigration and not by hibernate. THIS TASK IS NOT CLUSTER SAFE NOR THREAD
 * SAFE! IT IS JUST A TEMPORARY PATCH.
 * @author Danilo Ghirardelli
 */
public class PostGreSQLSequenceChecker extends GenericConditionalTask
{

    /**
     * Enable this task.
     */
    private boolean enabled = true;

    private Long offset = 1L;

    /**
     * @param enabled the enabled to set
     */
    public void setEnabled(boolean enabled)
    {
        this.enabled = enabled;
    }

    /**
     * Sets the offset that will be added to the maximum value of the sequence. In production should be 1, in test may
     * be big.
     * @param offset
     */
    public void setOffset(Long offset)
    {
        this.offset = offset;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    @SuppressWarnings("unchecked")
    public void execute(DataSource dataSource)
    {
        if (!enabled)
        {
            return;
        }
        if (!((Boolean) new JdbcTemplate(dataSource).execute(new ConnectionCallback()
        {

            public Object doInConnection(Connection con) throws SQLException, DataAccessException
            {
                return StringUtils.equalsIgnoreCase(con.getMetaData().getDatabaseProductName(), "PostgreSQL");
            }
        })))
        {
            log.info("Skipping sequences adjustment, not the right db.");
            return;
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        List<String> tables = (List<String>) jdbcTemplate.execute(new ConnectionCallback()
        {

            public Object doInConnection(Connection con) throws SQLException, DataAccessException
            {
                List<String> tables = new ArrayList<String>();
                ResultSet dbTables = con.getMetaData().getTables(null, null, null, new String[]{"TABLE" });
                while (dbTables.next())
                {
                    tables.add(dbTables.getString("TABLE_NAME"));
                }
                return tables;
            }
        });
        for (String tableName : tables)
        {
            if (jdbcTemplate
                .queryForLong("SELECT COUNT(*) FROM information_schema.sequences WHERE SEQUENCE_NAME ILIKE '"
                    + tableName
                    + "_id_seq'") > 0)
            {
                String idColumnName = (String) jdbcTemplate.queryForObject(
                    "SELECT COLUMN_NAME FROM information_schema.columns WHERE TABLE_NAME ILIKE '"
                        + tableName
                        + "' AND COLUMN_DEFAULT ILIKE 'nextval(%"
                        + tableName
                        + "_id_seq%'",
                    String.class);
                long tableRows = jdbcTemplate.queryForLong("SELECT MAX(" + idColumnName + ") FROM " + tableName);
                long sequenceVal = jdbcTemplate.queryForLong("SELECT last_value FROM " + tableName + "_id_seq");
                if ((sequenceVal >= 0) && (tableRows > sequenceVal))
                {
                    jdbcTemplate.execute("SELECT setval('"
                        + tableName
                        + "_id_seq', "
                        + Long.toString(tableRows + offset)
                        + ")");
                    log.info("Moved sequence \"{}_id_seq\" value from {} to {}.", new Object[]{
                        tableName,
                        sequenceVal,
                        (tableRows + offset) });
                    jdbcTemplate.execute("REINDEX TABLE " + tableName);
                    log.info("Reindexed table: " + tableName);
                }
            }
        }
    }
}