/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.migration;

import it.openutils.migration.DbVersionManager;
import javax.sql.DataSource;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class DefaultDbVersionManagerImpl
implements DbVersionManager {
    private String versionQuery;
    private String versionUpdate;
    private String versionCreate;
    private DataSource dataSource;

    public void setVersionCreate(String versionCreate) {
        this.versionCreate = versionCreate;
    }

    public void setVersionQuery(String versionQuery) {
        this.versionQuery = versionQuery;
    }

    public void setVersionUpdate(String versionUpdate) {
        this.versionUpdate = versionUpdate;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public int getCurrentVersion() {
        SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(this.dataSource);
        int initialVersion = 0;
        try {
            initialVersion = jdbcTemplate.queryForInt(this.versionQuery, new Object[0]);
        }
        catch (EmptyResultDataAccessException e) {
            jdbcTemplate.update(this.versionCreate, new Object[0]);
        }
        return initialVersion;
    }

    public void setNewVersion(int version) {
        new SimpleJdbcTemplate(this.dataSource).update(this.versionUpdate, new Object[]{version});
    }
}

