/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.migration.generic;

import it.openutils.migration.task.setup.BaseConditionalTask;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcIfColumnIndexExistsConditionalTask
extends BaseConditionalTask {
    protected String catalog;
    protected String schema;
    protected String table;
    protected String[] columns;
    private Logger log = LoggerFactory.getLogger(JdbcIfColumnIndexExistsConditionalTask.class);

    @Override
    public boolean check(SimpleJdbcTemplate jdbcTemplate) {
        TreeSet<IndexItem> indexExpected = new TreeSet<IndexItem>();
        this.checkInputs(indexExpected);
        ConnectionCallback action = new ConnectionCallback(){

            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                DatabaseMetaData dbMetadata = con.getMetaData();
                ResultSet rs = dbMetadata.getIndexInfo(JdbcIfColumnIndexExistsConditionalTask.this.catalog, JdbcIfColumnIndexExistsConditionalTask.this.schema, JdbcIfColumnIndexExistsConditionalTask.this.table, false, false);
                HashMap<String, TreeSet<IndexItem>> indexs = new HashMap<String, TreeSet<IndexItem>>();
                while (rs.next()) {
                    String indexName = rs.getString("INDEX_NAME");
                    String actualColumnName = rs.getString("COLUMN_NAME");
                    int position = rs.getInt("ORDINAL_POSITION");
                    TreeSet<IndexItem> indexItems = (TreeSet<IndexItem>)indexs.get(indexName);
                    if (indexItems == null) {
                        indexItems = new TreeSet<IndexItem>();
                        indexs.put(indexName, indexItems);
                    }
                    indexItems.add(new IndexItem(actualColumnName, position));
                }
                rs.close();
                return indexs.values();
            }
        };
        Collection indexs = (Collection)jdbcTemplate.getJdbcOperations().execute(action);
        this.log.debug("Expected:{}", (Object)JdbcIfColumnIndexExistsConditionalTask.asString(indexExpected));
        for (Set index : indexs) {
            this.log.debug("Actual:{}", (Object)JdbcIfColumnIndexExistsConditionalTask.asString(index));
            if (index.size() != indexExpected.size() || !JdbcIfColumnIndexExistsConditionalTask.asString(index).equalsIgnoreCase(JdbcIfColumnIndexExistsConditionalTask.asString(indexExpected))) continue;
            return true;
        }
        return false;
    }

    private void checkInputs(Set<IndexItem> indexExpected) {
        if (StringUtils.isBlank((String)this.table)) {
            throw new IllegalArgumentException("table is mandatory");
        }
        if (ArrayUtils.isEmpty((Object[])this.columns)) {
            throw new IllegalArgumentException("columns are mandatory");
        }
        for (int i = 0; i < this.columns.length; ++i) {
            String columnName = this.columns[i];
            if (StringUtils.isBlank((String)columnName)) {
                throw new IllegalArgumentException("columnName can not be blank");
            }
            indexExpected.add(new IndexItem(columnName, i + 1));
        }
    }

    private static final String asString(Set<IndexItem> index) {
        StringBuilder sb = new StringBuilder();
        for (IndexItem indexItem : index) {
            sb.append("" + indexItem.position + "|" + indexItem.columnName);
        }
        return sb.toString();
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void setColumns(String[] columns) {
        this.columns = columns;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IndexItem
    implements Comparable<IndexItem> {
        private String columnName;
        private int position;

        private IndexItem(String columnName, int position) {
            this.columnName = columnName;
            this.position = position;
        }

        @Override
        public int compareTo(IndexItem o) {
            return this.position - o.position;
        }

        public int hashCode() {
            return new HashCodeBuilder(1066590407, 744017859).append(this.position).append((Object)this.columnName).toHashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof IndexItem)) {
                return false;
            }
            IndexItem rhs = (IndexItem)object;
            return new EqualsBuilder().append(this.position, rhs.position).append((Object)this.columnName, (Object)rhs.columnName).isEquals();
        }
    }
}

