/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.migration.generic;

import it.openutils.migration.task.setup.BaseConditionalTask;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class JdbcIfForeignKeyExistsConditionalTask
extends BaseConditionalTask {
    private String fkName;
    private String catalog;
    private String schema;

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setFkName(String fkName) {
        this.fkName = fkName;
    }

    public boolean check(SimpleJdbcTemplate jdbcTemplate) {
        String fkNameTrim = StringUtils.trim((String)this.fkName);
        final String tableName = StringUtils.substringBefore((String)fkNameTrim, (String)".");
        final String fkName = StringUtils.substringAfter((String)fkNameTrim, (String)".");
        return (Boolean)jdbcTemplate.getJdbcOperations().execute(new ConnectionCallback(){

            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                boolean fkExists = false;
                DatabaseMetaData dbMetadata = con.getMetaData();
                ResultSet rs = dbMetadata.getExportedKeys(JdbcIfForeignKeyExistsConditionalTask.this.catalog, JdbcIfForeignKeyExistsConditionalTask.this.schema, tableName);
                while (rs.next()) {
                    if (!StringUtils.equals((String)fkName, (String)rs.getString("FK_NAME"))) continue;
                    fkExists = true;
                }
                rs.close();
                return fkExists;
            }
        });
    }
}

