/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.migration.generic;

import it.openutils.migration.task.setup.BaseConditionalTask;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcIfPrimaryKeyExistsConditionalTask
extends BaseConditionalTask {
    protected String catalog;
    protected String schema;
    protected String table;
    private Logger log = LoggerFactory.getLogger(JdbcIfPrimaryKeyExistsConditionalTask.class);

    @Override
    public boolean check(SimpleJdbcTemplate jdbcTemplate) {
        this.checkInputs();
        ConnectionCallback action = new ConnectionCallback(){

            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                DatabaseMetaData dbMetadata = con.getMetaData();
                ResultSet rs = dbMetadata.getPrimaryKeys(JdbcIfPrimaryKeyExistsConditionalTask.this.catalog, JdbcIfPrimaryKeyExistsConditionalTask.this.schema, JdbcIfPrimaryKeyExistsConditionalTask.this.table);
                TreeMap<Integer, String> primaryKey = new TreeMap<Integer, String>();
                while (rs.next()) {
                    String actualColumnName = rs.getString("COLUMN_NAME");
                    Integer position = rs.getInt("KEY_SEQ");
                    primaryKey.put(position, actualColumnName);
                }
                rs.close();
                return primaryKey.values();
            }
        };
        Collection primaryKeyActual = (Collection)jdbcTemplate.getJdbcOperations().execute(action);
        this.log.debug("Actual:{}", (Object)JdbcIfPrimaryKeyExistsConditionalTask.asString(primaryKeyActual));
        return !primaryKeyActual.isEmpty();
    }

    private void checkInputs() {
        if (StringUtils.isBlank((String)this.table)) {
            throw new IllegalArgumentException("table is mandatory");
        }
    }

    private static final String asString(Collection<String> primaryKey) {
        StringBuilder sb = new StringBuilder();
        int position = 0;
        for (String pkColumn : primaryKey) {
            sb.append("" + position + "|" + pkColumn);
            ++position;
        }
        return sb.toString();
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setTable(String table) {
        this.table = table;
    }
}

