/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.migration.generic;

import it.openutils.migration.task.setup.GenericConditionalTask;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public abstract class JdbcObjectCreationTask
extends GenericConditionalTask {
    protected String catalog;
    protected String schema;

    abstract String getObjectType();

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DataSource dataSource) {
        SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(dataSource);
        for (Resource script : this.scripts) {
            if (script == null || !script.exists()) {
                this.log.error("Unable to execute db task \"{}\", script \"{}\" not found.", (Object)this.getDescription(), (Object)script);
                return;
            }
            String fqTableName = this.objectNameFromFileName(script);
            String tmptableName = null;
            String tmpschema = this.schema;
            if (StringUtils.contains((String)fqTableName, (String)".")) {
                String[] tokens = StringUtils.split((String)fqTableName, (String)".");
                tmptableName = tokens[1];
                tmpschema = tokens[0];
            } else {
                tmptableName = fqTableName;
            }
            final String tableName = tmptableName;
            final String schema = tmpschema;
            boolean result = (Boolean)new JdbcTemplate(dataSource).execute(new ConnectionCallback(){

                public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                    DatabaseMetaData dbMetadata = con.getMetaData();
                    ResultSet rs = dbMetadata.getTables(JdbcObjectCreationTask.this.catalog, schema, tableName, new String[]{JdbcObjectCreationTask.this.getObjectType()});
                    boolean tableExists = rs.next();
                    rs.close();
                    return tableExists;
                }
            });
            if (!result) {
                String scriptContent;
                InputStream is = null;
                try {
                    is = script.getInputStream();
                    scriptContent = IOUtils.toString((InputStream)is, (String)"UTF8");
                    scriptContent = this.performSubstitution(scriptContent);
                }
                catch (IOException e) {
                    this.log.error("Unable to execute db task \"{}\", script \"{}\" can't be read.", (Object)this.getDescription(), (Object)script);
                    return;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
                String[] ddls = StringUtils.split((String)scriptContent, (String)";");
                this.log.info("Creating new {} {}", (Object)this.getObjectType(), (Object)tableName);
                for (String ddl : ddls) {
                    if (!StringUtils.isNotBlank((String)ddl)) continue;
                    this.log.debug("Executing:\n{}", (Object)ddl);
                    jdbcTemplate.update(ddl, new Object[0]);
                }
                continue;
            }
            this.log.debug("{} {} already existing", (Object)this.getObjectType(), (Object)tableName);
        }
    }
}

