/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.migration.oracle;

import it.openutils.migration.task.setup.DbTask;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OraclePackageCreationTask
implements DbTask {
    private Logger log = LoggerFactory.getLogger(OraclePackageCreationTask.class);
    private List<Resource> scripts;
    private String selectUserPackages = "select COUNT(*) FROM USER_OBJECTS WHERE OBJECT_NAME = ? and OBJECT_TYPE='PACKAGE'";
    private String selectAllPackages = "SELECT COUNT(*) from ALL_OBJECTS where OBJECT_NAME = ? AND OBJECT_TYPE='PACKAGE' AND OWNER = ?";
    protected Map<String, String> variables;

    public void setScripts(List<Resource> packages) {
        this.scripts = packages;
    }

    public void setSelectAllPackages(String selectAllPackages) {
        this.selectAllPackages = selectAllPackages;
    }

    public void setSelectUserPackages(String selectUserPackages) {
        this.selectUserPackages = selectUserPackages;
    }

    public void setVariables(Map<String, String> variables) {
        this.variables = variables;
    }

    @Override
    public String getDescription() {
        return "Checking Packages";
    }

    protected String objectNameFromFileName(Resource script) {
        return StringUtils.substringBeforeLast((String)script.getFilename(), (String)".");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(DataSource dataSource) {
        SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(dataSource);
        for (Resource script : this.scripts) {
            if (script == null || !script.exists()) {
                this.log.error("Unable to execute db task \"{}\", script \"{}\" not found.", (Object)this.getDescription(), (Object)script);
                return;
            }
            String fqPackageName = this.objectNameFromFileName(script);
            String tmpPackageName = null;
            String tmpowner = null;
            if (StringUtils.contains((String)fqPackageName, (String)".")) {
                String[] tokens = StringUtils.split((String)fqPackageName, (String)".");
                tmpPackageName = tokens[1];
                tmpowner = tokens[0];
            } else {
                tmpPackageName = fqPackageName;
            }
            String packageName = tmpPackageName;
            String owner = tmpowner;
            int result = 0;
            result = StringUtils.isNotBlank(owner) ? jdbcTemplate.queryForInt(this.selectAllPackages, new Object[]{packageName, owner}) : jdbcTemplate.queryForInt(this.selectUserPackages, new Object[]{packageName});
            if (result <= 0) {
                String scriptContent;
                InputStream is = null;
                try {
                    is = script.getInputStream();
                    scriptContent = IOUtils.toString((InputStream)is, (String)"UTF8");
                    scriptContent = scriptContent.replaceAll("\\s*\n\\s*", "\n");
                }
                catch (IOException e) {
                    this.log.error("Unable to execute db task \"{}\", script \"{}\" can't be read.", (Object)this.getDescription(), (Object)script);
                    return;
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                }
                String[] scriptSections = scriptContent.split("/");
                String packageHeader = this.performSubstitution(scriptSections[0].trim());
                String packageBody = this.performSubstitution(scriptSections[1].trim());
                if (!StringUtils.isNotBlank((String)packageHeader) || !StringUtils.isNotBlank((String)packageBody)) continue;
                this.log.info("Creating new package header for {}", (Object)packageName);
                jdbcTemplate.update(packageHeader, new Object[0]);
                this.log.info("Creating new package body for {}", (Object)packageName);
                jdbcTemplate.update(packageBody, new Object[0]);
                continue;
            }
            this.log.debug("Package {} already existing", (Object)packageName);
        }
    }

    protected String performSubstitution(String string) {
        if (this.variables == null || this.variables.isEmpty()) {
            return string;
        }
        String stringReplaced = string;
        for (String key : this.variables.keySet()) {
            stringReplaced = StringUtils.replace((String)stringReplaced, (String)("${" + key + "}"), (String)this.variables.get(key));
        }
        return stringReplaced;
    }
}

