/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.migration.oracle;

import it.openutils.migration.task.setup.DbTask;
import java.text.MessageFormat;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleSequenceCreationTask
implements DbTask {
    private Logger log = LoggerFactory.getLogger(OracleSequenceCreationTask.class);
    private List<String> sequences;
    private String creationQuery = "CREATE SEQUENCE {0} INCREMENT BY 1 START WITH {1} MAXVALUE 1E28 MINVALUE 1 NOCACHE NOCYCLE ORDER";
    private String selectUserSequences = "SELECT COUNT(*) FROM USER_SEQUENCES WHERE SEQUENCE_NAME = ?";
    private String selectAllSequences = "SELECT COUNT(*) FROM ALL_SEQUENCES WHERE SEQUENCE_NAME = ? AND SEQUENCE_OWNER = ?";
    private int startsWith = 1;

    public void setSequences(List<String> sequences) {
        this.sequences = sequences;
    }

    public void setCreationQuery(String creationQuery) {
        this.creationQuery = creationQuery;
    }

    public void setSelectAllSequences(String selectAllSequences) {
        this.selectAllSequences = selectAllSequences;
    }

    public void setStartsWith(int startsWith) {
        this.startsWith = startsWith;
    }

    public void setSelectUserSequences(String selectUserSequences) {
        this.selectUserSequences = selectUserSequences;
    }

    @Override
    public String getDescription() {
        return "Checking Sequences";
    }

    @Override
    public void execute(DataSource dataSource) {
        SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(dataSource);
        for (String sequenceName : this.sequences) {
            int result = 0;
            if (StringUtils.contains((String)sequenceName, (String)".")) {
                String[] tokens = StringUtils.split((String)sequenceName, (String)".");
                result = jdbcTemplate.queryForInt(this.selectAllSequences, new Object[]{tokens[1], tokens[0]});
            } else {
                result = jdbcTemplate.queryForInt(this.selectUserSequences, new Object[]{sequenceName});
            }
            if (result > 0) continue;
            this.log.info("Creating new {}", (Object)sequenceName);
            jdbcTemplate.update(MessageFormat.format(this.creationQuery, sequenceName, String.valueOf(this.startsWith)), new Object[0]);
        }
    }
}

