/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.migration.postgres;

import it.openutils.migration.task.setup.GenericConditionalTask;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public class PostGreSQLSequenceChecker
extends GenericConditionalTask {
    private boolean enabled = true;
    private Long offset = 1L;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    public void execute(DataSource dataSource) {
        if (!this.enabled) {
            return;
        }
        if (!((Boolean)new JdbcTemplate(dataSource).execute(new ConnectionCallback(){

            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                return StringUtils.equalsIgnoreCase((String)con.getMetaData().getDatabaseProductName(), (String)"PostgreSQL");
            }
        })).booleanValue()) {
            this.log.info("Skipping sequences adjustment, not the right db.");
            return;
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        List tables = (List)jdbcTemplate.execute(new ConnectionCallback(){

            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                ArrayList<String> tables = new ArrayList<String>();
                ResultSet dbTables = con.getMetaData().getTables(null, null, null, new String[]{"TABLE"});
                while (dbTables.next()) {
                    tables.add(dbTables.getString("TABLE_NAME"));
                }
                return tables;
            }
        });
        for (String tableName : tables) {
            if (jdbcTemplate.queryForLong("SELECT COUNT(*) FROM information_schema.sequences WHERE SEQUENCE_NAME ILIKE '" + tableName + "_id_seq'") <= 0L) continue;
            String idColumnName = (String)jdbcTemplate.queryForObject("SELECT COLUMN_NAME FROM information_schema.columns WHERE TABLE_NAME ILIKE '" + tableName + "' AND COLUMN_DEFAULT ILIKE 'nextval(%" + tableName + "_id_seq%'", String.class);
            long tableRows = jdbcTemplate.queryForLong("SELECT MAX(" + idColumnName + ") FROM " + tableName);
            long sequenceVal = jdbcTemplate.queryForLong("SELECT last_value FROM " + tableName + "_id_seq");
            if (sequenceVal < 0L || tableRows <= sequenceVal) continue;
            jdbcTemplate.execute("SELECT setval('" + tableName + "_id_seq', " + Long.toString(tableRows + this.offset) + ")");
            this.log.info("Moved sequence \"{}_id_seq\" value from {} to {}.", new Object[]{tableName, sequenceVal, tableRows + this.offset});
            jdbcTemplate.execute("REINDEX TABLE " + tableName);
            this.log.info("Reindexed table: " + tableName);
        }
    }
}

