/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.migration.sqlserver;

import it.openutils.migration.task.setup.GenericConditionalTask;
import java.io.IOException;
import java.io.InputStream;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class SqlServerObjCreationTask
extends GenericConditionalTask {
    private String unqualifiedObjQuery;
    private String qualifiedObjQuery;

    public String getQualifiedObjQuery() {
        return this.qualifiedObjQuery;
    }

    public void setQualifiedObjQuery(String qualifiedObjQuery) {
        this.qualifiedObjQuery = qualifiedObjQuery;
    }

    public String getUnqualifiedObjQuery() {
        return this.unqualifiedObjQuery;
    }

    public void setUnqualifiedObjQuery(String unqualifiedObjQuery) {
        this.unqualifiedObjQuery = unqualifiedObjQuery;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DataSource dataSource) {
        SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(dataSource);
        for (Resource script : this.scripts) {
            String[] ddls;
            String scriptContent;
            String fqTableName = this.objectNameFromFileName(script);
            int result = 0;
            if (StringUtils.contains((String)fqTableName, (String)".")) {
                String[] tokens = StringUtils.split((String)fqTableName, (String)".");
                result = jdbcTemplate.queryForInt(this.qualifiedObjQuery, new Object[]{tokens[1], tokens[0]});
            } else {
                result = jdbcTemplate.queryForInt(this.unqualifiedObjQuery, new Object[]{fqTableName});
            }
            if (result != 0) continue;
            if (script == null || !script.exists()) {
                this.log.error("Unable to execute db task \"{}\", script \"{}\" not found.", (Object)this.getDescription(), (Object)script);
                return;
            }
            InputStream is = null;
            try {
                is = script.getInputStream();
                scriptContent = IOUtils.toString((InputStream)is, (String)"UTF8");
            }
            catch (IOException e) {
                this.log.error("Unable to execute db task \"{}\", script \"{}\" can't be read.", (Object)this.getDescription(), (Object)script);
                return;
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
            for (String ddl : ddls = StringUtils.split((String)scriptContent, (String)";")) {
                if (!StringUtils.isNotBlank((String)ddl)) continue;
                String ddlReplaced = this.performSubstitution(ddl);
                this.log.debug("Executing:\n{}", (Object)ddlReplaced);
                jdbcTemplate.update(ddlReplaced, new Object[0]);
            }
        }
    }
}

