/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.migration.sqlserver;

import it.openutils.migration.task.setup.DbTask;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlServerSynonymCreationTask
implements DbTask {
    private String source;
    private List<String> objects;

    public void setSource(String source) {
        this.source = source;
    }

    public void setObjects(List<String> objects) {
        this.objects = objects;
    }

    @Override
    public void execute(DataSource dataSource) {
        SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(dataSource);
        for (String objectName : this.objects) {
            int result = jdbcTemplate.queryForInt("select count(*) from dbo.sysobjects where id = object_id(?) and xtype = N'SN'", new Object[]{objectName});
            if (result != 0) continue;
            jdbcTemplate.update("CREATE SYNONYM [dbo].[" + objectName + "] FOR [" + this.source + "].[dbo].[" + objectName + "]", new Object[0]);
        }
    }

    @Override
    public String getDescription() {
        return "Creating synonyms from " + this.source;
    }
}

