/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.migration.task.setup;

import it.openutils.migration.task.setup.BaseDbTask;
import it.openutils.migration.task.setup.DbTask;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseConditionalTaskList
extends BaseDbTask {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    private String databaseProductName;
    private String databaseProductVersion;
    private List<DbTask> tasks;

    public void setDatabaseProductName(String databaseProductName) {
        this.databaseProductName = databaseProductName;
    }

    public void setDatabaseProductVersion(String databaseProductVersion) {
        this.databaseProductVersion = databaseProductVersion;
    }

    public void setTasks(List<DbTask> tasks) {
        this.tasks = tasks;
    }

    @Override
    public void execute(DataSource dataSource) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        String databaseRealProductName = (String)jdbcTemplate.execute(new ConnectionCallback(){

            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                return con.getMetaData().getDatabaseProductName();
            }
        });
        String databaseRealProductVersion = (String)jdbcTemplate.execute(new ConnectionCallback(){

            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                return con.getMetaData().getDatabaseProductVersion();
            }
        });
        if (StringUtils.isNotEmpty((String)this.databaseProductName) && !StringUtils.equalsIgnoreCase((String)databaseRealProductName, (String)this.databaseProductName)) {
            this.log.info("Skipping tasks for specific database: " + this.databaseProductName + " Database found: " + databaseRealProductName);
            return;
        }
        if (StringUtils.isNotEmpty((String)this.databaseProductVersion) && !StringUtils.equalsIgnoreCase((String)databaseRealProductVersion, (String)this.databaseProductVersion)) {
            this.log.info("Skipping tasks for specific database version: " + this.databaseProductVersion + " Database version found: " + databaseRealProductVersion);
            return;
        }
        for (DbTask task : this.tasks) {
            this.log.debug(task.getDescription());
            task.execute(dataSource);
        }
    }
}

