/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.migration.task.setup;

import it.openutils.migration.task.setup.BaseDbTask;
import it.openutils.migration.task.setup.DbTask;
import it.openutils.migration.task.setup.ScriptBasedUnconditionalTask;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.jdbc.BadSqlGrammarException;
import org.springframework.jdbc.core.ColumnMapRowMapper;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelConfigurationTask
extends BaseDbTask
implements DbTask {
    private Logger log = LoggerFactory.getLogger(ScriptBasedUnconditionalTask.class);
    private Resource script;
    private Map<String, QueryConfig> config;
    private boolean enabled = true;
    private boolean updateEnabled = true;
    private SimpleDateFormat isodateformat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");

    public void setScript(Resource script) {
        this.script = script;
    }

    public void setConfig(Map<String, QueryConfig> config) {
        this.config = config;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setUpdateEnabled(boolean updateEnabled) {
        this.updateEnabled = updateEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(DataSource dataSource) {
        if (!this.enabled) {
            return;
        }
        if (this.script == null || !this.script.exists()) {
            this.log.error("Unable to execute db task \"{}\", script \"{}\" not found.", (Object)this.getDescription(), (Object)this.script);
            return;
        }
        InputStream is = null;
        try {
            is = this.script.getInputStream();
            POIFSFileSystem fs = new POIFSFileSystem(is);
            HSSFWorkbook hssfworkbook = new HSSFWorkbook(fs);
            int sheetNums = hssfworkbook.getNumberOfSheets();
            for (int j = 0; j < sheetNums; ++j) {
                HSSFSheet sheet = hssfworkbook.getSheetAt(j);
                String sheetName = StringUtils.trim((String)hssfworkbook.getSheetName(j));
                QueryConfig conf = this.config.get(sheetName);
                if (conf == null) {
                    this.suggestSheetConfig(sheet, sheetName, conf, dataSource);
                    continue;
                }
                String tableName = StringUtils.isBlank((String)conf.getTableName()) ? sheetName : conf.getTableName();
                this.processSheet(sheet, tableName, conf, dataSource);
            }
        }
        catch (IOException e) {
            this.log.error(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public void suggestSheetConfig(HSSFSheet sheet, String tableName, QueryConfig con, DataSource dataSource) {
        this.log.error("Unable to handle table {}", (Object)tableName);
        if (!this.log.isDebugEnabled()) {
            return;
        }
        ArrayList<String> columns = new ArrayList<String>();
        HSSFRow row = sheet.getRow(0);
        for (short k = 0; k < row.getLastCellNum(); k = (short)(k + 1)) {
            HSSFCell cell = row.getCell(k);
            if (cell == null) continue;
            String columnName = cell.getStringCellValue();
            if (!StringUtils.isNotBlank((String)columnName)) break;
            columns.add(StringUtils.trim((String)columnName));
        }
        if (columns.isEmpty()) {
            return;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("        <entry key=\"");
        buffer.append(tableName);
        buffer.append("\">\n          <bean class=\"it.openutils.migration.task.setup.ExcelConfigurationTask$QueryConfig\">\n            <property name=\"checkQuery\">\n              <value>");
        String initialCol = (String)columns.get(0);
        buffer.append("select count(" + initialCol + ") from " + tableName + " where " + initialCol + " = ?");
        buffer.append("</value>\n            </property>\n            <property name=\"insertQuery\">\n              <value>");
        buffer.append("INSERT INTO ");
        buffer.append(tableName);
        buffer.append(" (");
        StringBuffer colNames = new StringBuffer();
        StringBuffer parNames = new StringBuffer();
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            colNames.append(string);
            parNames.append("?");
            if (!iterator.hasNext()) continue;
            colNames.append(", ");
            parNames.append(", ");
        }
        buffer.append(colNames);
        buffer.append(") VALUES (");
        buffer.append(parNames);
        buffer.append(")");
        buffer.append("</value>\n            </property>\n          </bean>\n        </entry>");
        this.log.debug("You can use the following suggested config as template:\n{}", (Object)buffer.toString());
    }

    private void processSheet(HSSFSheet sheet, final String tableName, QueryConfig con, DataSource dataSource) {
        final ArrayList<String> columns = new ArrayList<String>();
        HSSFRow row = sheet.getRow(0);
        for (short k = 0; k < row.getLastCellNum(); k = (short)(k + 1)) {
            HSSFCell cell = row.getCell(k);
            if (cell == null) continue;
            String columnName = cell.getStringCellValue();
            if (!StringUtils.isNotBlank((String)columnName)) break;
            columns.add(StringUtils.trim((String)columnName));
        }
        this.log.debug("Table: {}, Columns: {}", (Object)tableName, columns);
        final ArrayList types = new ArrayList();
        boolean result = (Boolean)new JdbcTemplate(dataSource).execute(new ConnectionCallback(){

            public Object doInConnection(Connection con) throws SQLException, DataAccessException {
                for (String column : columns) {
                    ResultSet res = con.getMetaData().getColumns(null, null, tableName, column);
                    if (res.next()) {
                        types.add(res.getInt("DATA_TYPE"));
                    } else {
                        res.close();
                        res = con.getMetaData().getColumns(null, null, StringUtils.lowerCase((String)tableName), StringUtils.lowerCase((String)column));
                        if (res.next()) {
                            types.add(res.getInt("DATA_TYPE"));
                        } else {
                            ExcelConfigurationTask.this.log.warn("Unable to determine type for column '{}' in table '{}'", (Object)column, (Object)tableName);
                            return false;
                        }
                    }
                    res.close();
                }
                return true;
            }
        });
        if (result) {
            String checkStatement = StringUtils.remove((String)StringUtils.trim((String)con.getCheckQuery()), (String)"\n");
            String insertStatement = StringUtils.remove((String)StringUtils.trim((String)con.getInsertQuery()), (String)"\n");
            String selectStatement = StringUtils.remove((String)StringUtils.trim((String)con.getSelectQuery()), (String)"\n");
            String updateStatement = StringUtils.remove((String)StringUtils.trim((String)con.getUpdateQuery()), (String)"\n");
            this.processRecords(sheet, columns, ArrayUtils.toPrimitive((Integer[])types.toArray(new Integer[types.size()]), (int)0), checkStatement, insertStatement, selectStatement, updateStatement, dataSource, tableName);
        } else {
            this.log.warn("Skipping sheet {} ", (Object)tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processRecords(HSSFSheet sheet, List<String> columns, int[] types, String checkStatement, String insertStatement, String selectStatement, String updateStatement, DataSource dataSource, String tableName) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
        int checkNum = StringUtils.countMatches((String)checkStatement, (String)"?");
        int insertNum = StringUtils.countMatches((String)insertStatement, (String)"?");
        int selectNum = StringUtils.countMatches((String)selectStatement, (String)"?");
        int updateNum = StringUtils.countMatches((String)updateStatement, (String)"?");
        for (int rowNum = 1; rowNum <= sheet.getLastRowNum(); rowNum = (int)((short)(rowNum + 1))) {
            int existing;
            HSSFRow row = sheet.getRow(rowNum);
            if (row == null) {
                return;
            }
            ArrayList<String> values = new ArrayList<String>();
            for (short k = 0; k < columns.size() && k <= row.getLastCellNum(); k = (short)(k + 1)) {
                HSSFCell cell = row.getCell(k);
                String value = null;
                if (cell == null) {
                    value = "";
                } else if (cell.getCellType() == 1) {
                    value = cell.getStringCellValue();
                } else if (cell.getCellType() == 0) {
                    double valueDouble = cell.getNumericCellValue();
                    double fraction = valueDouble % 1.0;
                    value = fraction == 0.0 ? Long.toString((long)valueDouble) : Double.toString(valueDouble);
                }
                if (StringUtils.isEmpty((String)value)) {
                    value = "";
                }
                if ("<NULL>".equalsIgnoreCase(value)) {
                    value = null;
                }
                values.add(value);
            }
            Object[] checkParams = ArrayUtils.subarray((Object[])values.toArray(), (int)0, (int)checkNum);
            int[] checkParamTypes = ArrayUtils.subarray((int[])types, (int)0, (int)checkNum);
            for (int i = 0; i < checkParams.length; ++i) {
                if (!StringUtils.isEmpty((String)((String)checkParams[i]))) continue;
                return;
            }
            try {
                existing = jdbcTemplate.queryForInt(checkStatement, checkParams, checkParamTypes);
            }
            catch (BadSqlGrammarException bsge) {
                this.log.error("Error executing check query, current sheet will be skipped. {} Query in error: {}", (Object)bsge.getMessage(), (Object)checkStatement);
                return;
            }
            if (existing == 0) {
                Object[] insertParams = ArrayUtils.subarray((Object[])values.toArray(), (int)0, (int)insertNum);
                int[] insertTypes = ArrayUtils.subarray((int[])types, (int)0, (int)insertNum);
                for (int j = 0; j < insertTypes.length; ++j) {
                    int tip = insertTypes[j];
                    if (tip != 1 && tip != -16 && tip != -1 && tip != -15 && tip != -9 && tip != 12 && "".equals(insertParams[j])) {
                        insertParams[j] = null;
                    }
                    if (tip != 91 && tip != 92 && (tip != 93 || insertParams[j] == null)) continue;
                    SimpleDateFormat simpleDateFormat = this.isodateformat;
                    synchronized (simpleDateFormat) {
                        try {
                            insertParams[j] = this.isodateformat.parse((String)insertParams[j]);
                        }
                        catch (ParseException e) {
                            this.log.debug("Cannot parse date \"{}\"", insertParams[j]);
                        }
                        continue;
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Missing record with key {}; inserting {}", (Object)ArrayUtils.toString((Object)checkParams), (Object)ArrayUtils.toString((Object)insertParams));
                }
                if (insertParams.length != insertTypes.length) {
                    this.log.warn("Invalid number of param/type for table {}. Params: {}, types: {}", new Object[]{tableName, insertParams.length, insertTypes.length});
                }
                try {
                    jdbcTemplate.update(insertStatement, insertParams, insertTypes);
                }
                catch (DataIntegrityViolationException bsge) {
                    this.log.error("Error executing update, record at {}:{} will be skipped. Query in error: '{}', values: {}. Error message: {}", new Object[]{tableName, rowNum + 1, insertStatement, ArrayUtils.toString((Object)insertParams), bsge.getMessage()});
                }
                continue;
            }
            if (!this.updateEnabled || !StringUtils.isNotBlank((String)updateStatement) || !StringUtils.isNotBlank((String)selectStatement)) continue;
            try {
                ColumnMapRowMapper rowMapper = new ColumnMapRowMapper();
                Object[] selectParams = ArrayUtils.subarray((Object[])values.toArray(), (int)0, (int)selectNum);
                List selectResult = jdbcTemplate.query(selectStatement, selectParams, (RowMapper)rowMapper);
                Map fetchedColumns = (Map)selectResult.get(0);
                int i = 0;
                boolean updateNeeded = false;
                for (String columnName : columns) {
                    Object columnObject = fetchedColumns.get(columnName);
                    if (columnObject == null) continue;
                    String columnValue = ObjectUtils.toString(fetchedColumns.get(columnName));
                    if (!StringUtils.equals((String)columnValue, (String)((String)values.get(i)))) {
                        updateNeeded = true;
                        break;
                    }
                    ++i;
                }
                if (!updateNeeded) continue;
                Object[] updateParams = ArrayUtils.subarray((Object[])values.toArray(), (int)0, (int)updateNum);
                int[] insertTypes = ArrayUtils.subarray((int[])types, (int)0, (int)insertNum);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Missing record with key {}; updating {}", (Object)ArrayUtils.toString((Object)checkParams), (Object)ArrayUtils.toString((Object)updateParams));
                }
                if (updateParams.length != insertTypes.length) {
                    this.log.warn("Invalid number of param/type for table {}. Params: {}, types: {}", new Object[]{tableName, updateParams.length, insertTypes.length});
                }
                try {
                    Object[] compoundUpdateParams = new Object[checkParams.length + updateParams.length];
                    System.arraycopy(updateParams, 0, compoundUpdateParams, 0, updateParams.length);
                    System.arraycopy(checkParams, 0, compoundUpdateParams, compoundUpdateParams.length - 1, checkParams.length);
                    jdbcTemplate.update(updateStatement, compoundUpdateParams);
                }
                catch (DataIntegrityViolationException bsge) {
                    this.log.error("Error executing insert, record at {}:{} will be skipped. Query in error: '{}', values: {}. Error message: {}", new Object[]{tableName, rowNum + 1, insertStatement, ArrayUtils.toString((Object)updateParams), bsge.getMessage()});
                }
                continue;
            }
            catch (BadSqlGrammarException bsge) {
                this.log.error("Error executing query to load row values, current possible update of row will be skipped. {} Query in error: {}", (Object)bsge.getMessage(), (Object)checkStatement);
                return;
            }
        }
    }

    public static class QueryConfig {
        private String tableName;
        private String checkQuery;
        private String insertQuery;
        private String selectQuery;
        private String updateQuery;

        public String getSelectQuery() {
            return this.selectQuery;
        }

        public void setSelectQuery(String selectQuery) {
            this.selectQuery = selectQuery;
        }

        public String getCheckQuery() {
            return this.checkQuery;
        }

        public void setCheckQuery(String checkQuery) {
            this.checkQuery = checkQuery;
        }

        public String getInsertQuery() {
            return this.insertQuery;
        }

        public void setInsertQuery(String insertQuery) {
            this.insertQuery = insertQuery;
        }

        public String getUpdateQuery() {
            return this.updateQuery;
        }

        public void setUpdateQuery(String updateQuery) {
            this.updateQuery = updateQuery;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }
    }
}

