/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.migration.task.setup;

import it.openutils.migration.task.setup.BaseDbTask;
import it.openutils.migration.task.setup.DbTask;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScriptBasedUnconditionalTask
extends BaseDbTask
implements DbTask {
    private Logger log = LoggerFactory.getLogger(ScriptBasedUnconditionalTask.class);
    private List<Resource> scripts;

    public void setScripts(List<Resource> scripts) {
        this.scripts = scripts;
    }

    @Override
    public void execute(DataSource dataSource) {
        for (Resource script : this.scripts) {
            String scriptContent;
            if (script == null || !script.exists()) {
                this.log.error("Unable to execute db task \"{}\", script \"{}\" not found.", (Object)this.getDescription(), (Object)script);
                return;
            }
            try {
                scriptContent = IOUtils.toString((InputStream)script.getInputStream(), (String)"UTF8");
            }
            catch (IOException e) {
                this.log.error("Unable to execute db task \"{}\", script \"{}\" can't be read.", (Object)this.getDescription(), (Object)script);
                return;
            }
            String[] ddls = StringUtils.split((String)scriptContent, (String)";");
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(dataSource);
            for (String ddl : ddls) {
                if (!StringUtils.isNotBlank((String)ddl)) continue;
                this.log.debug("Executing:\n{}", (Object)ddl);
                jdbcTemplate.update(ddl, new Object[0]);
            }
        }
    }
}

