/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.migration.task.update;

import it.openutils.migration.task.setup.ScriptBasedUnconditionalTask;
import it.openutils.migration.task.update.DbUpdate;
import java.io.IOException;
import java.io.InputStream;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class ScriptBasedDbUpdate
implements DbUpdate {
    private Logger log = LoggerFactory.getLogger(ScriptBasedUnconditionalTask.class);
    private Resource script;
    private int version;
    private String description;

    public void setScript(Resource script) {
        this.script = script;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(DataSource dataSource) {
        String scriptContent;
        if (this.script == null || !this.script.exists()) {
            this.log.error("Unable to execute db task \"{}\", script \"{}\" not found.", (Object)this.getDescription(), (Object)this.script);
            return;
        }
        InputStream is = null;
        try {
            is = this.script.getInputStream();
            scriptContent = IOUtils.toString((InputStream)is, (String)"UTF8");
        }
        catch (IOException e) {
            this.log.error("Unable to execute db task \"{}\", script \"{}\" can't be read.", (Object)this.getDescription(), (Object)this.script);
            return;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
        String[] ddls = StringUtils.split((String)scriptContent, (String)";");
        SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(dataSource);
        for (String ddl : ddls) {
            if (!StringUtils.isNotBlank((String)ddl)) continue;
            this.log.debug("Executing:\n{}", (Object)ddl);
            jdbcTemplate.update(ddl, new Object[0]);
        }
    }
}

