/**
 *
 * openutils-elfunctions (http://www.openmindlab.com/lab/products/elfunctions.html)
 * Copyright(C) 2008-2010, Openmind S.r.l. http://www.openmindonline.it
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *       http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

package net.sourceforge.openutils.elfunctions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * @author dschivo
 * @version $Id: CollectionElUtils.java 2122 2010-03-09 20:02:04Z fgiust $
 */
public class CollectionElUtils
{

    /**
     * Logger.
     */
    private static Logger log = LoggerFactory.getLogger(CollectionElUtils.class);

    /**
     * Converts an array to a list
     * @param array an object array
     * @return a list representation of the array
     */
    public static List< ? > toList(Object[] array)
    {
        if (array == null)
        {
            return Collections.EMPTY_LIST;
        }
        return Arrays.asList(array);
    }

    /**
     * Randomly permutes the specified list
     * @param input the list to be shuffled
     * @return a shuffled list
     */
    public static List< ? > shuffle(List< ? > input)
    {
        if (input == null)
        {
            return null;
        }

        Collections.shuffle(input);
        return input;
    }

    /**
     * Retuns the set of Map.Entry from a Map (can be used to iterate on the map)
     * @param map Map
     * @return entry set
     */
    public static Set<Map.Entry> entryset(Map map)
    {
        if (map == null)
        {
            return null;
        }
        return map.entrySet();
    }

    /**
     * Splits a collection into pages of the specified size
     * @param collection the collection to split into pages
     * @param pageSize the maximum number of items per page
     * @return a list of pages, where each page is a list too
     */
    public static List<List> paginateCollection(Collection collection, int pageSize)
    {
        int index = 0;
        List<List> pages = new ArrayList<List>();
        List page = null;
        for (Object obj : collection)
        {
            if (index % pageSize == 0)
            {
                page = new ArrayList();
                pages.add(page);
            }
            page.add(obj);
            index++;
        }
        return pages;
    }

}
