/*
 * Copyright (c) Openmind.  All rights reserved. http://www.openmindonline.it
 */
package it.openutils.hibernate.security.services;

import it.openutils.hibernate.security.dataobject.SecurityRule;

import java.util.List;

import org.hibernate.Filter;


/**
 * @author fcarone
 * @version $Id: $
 */
public interface SecurityRuleManager
{

    /**
     * @return All the defined {@link SecurityRule}s.
     */
    List<SecurityRule> findAll();

    /**
     * @param filter The {@link SecurityRule} to use as search filter
     * @return The list of matching {@link SecurityRule}s.
     */
    List<SecurityRule> findFiltered(SecurityRule filter);

    /**
     * @param id The id of the {@link SecurityRule} to load
     * @return The {@link SecurityRule} with the given id
     */
    SecurityRule load(Long id);

    /**
     * @param id The id of the {@link SecurityRule} to load
     * @return The {@link SecurityRule} with the given id, or null if it is not found
     */
    SecurityRule loadIfAvailable(Long id);

    /**
     * @param id The security rule id
     * @return The removed {@link SecurityRule}
     */
    boolean delete(Long id);

    /**
     * @param securityRule The {@link SecurityRule} to save or update
     */
    void saveOrUpdate(SecurityRule securityRule);

    /**
     * @param securityRule The {@link SecurityRule} to save
     * @return The id of the saved {@link SecurityRule}
     */
    Long save(SecurityRule securityRule);

    /**
     * @param securityRule The {@link SecurityRule} to update
     */
    void update(SecurityRule securityRule);

    /**
     * @param entity The entity to apply rules for
     * @param rules The list of rules to apply
     * @return
     * @throws SecurityException
     * @throws ClassNotFoundException
     * @throws InstantiationException
     * @throws IllegalAccessException
     * @throws NoSuchFieldException
     */
    public Filter getEntityFilterFromRules(String entity, List<SecurityRule> rules) throws SecurityException,
        ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException;

    /**
     * @param entity The entity we want rules for
     * @param roles The list of roles
     * @return The list of security rules matching entity - roles
     */
    List<SecurityRule> getRulesForRoles(String entity, List<String> roles);
}
