/*
 * Copyright (c) Openmind.  All rights reserved. http://www.openmindonline.it
 */
package it.openutils.hibernate.security.services.impl;

import it.openutils.hibernate.security.dao.SecurityRuleDAO;
import it.openutils.hibernate.security.dataobject.SecurityRule;
import it.openutils.hibernate.security.filter.JavaBeanFilter;
import it.openutils.hibernate.security.services.SecurityRuleManager;

import java.util.ArrayList;
import java.util.List;

import org.hibernate.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * @author fcarone
 * @version $Id: $
 */
public class SecurityRuleManagerImpl implements SecurityRuleManager
{

    /**
     * Logger.
     */
    private Logger log = LoggerFactory.getLogger(SecurityRuleManagerImpl.class);

    private SecurityRuleDAO securityRuleDAO;

    /**
     * Sets the securityRuleDAO.
     * @param securityRuleDAO the securityRuleDAO to set
     */
    public void setSecurityRuleDAO(SecurityRuleDAO securityRuleDAO)
    {
        this.securityRuleDAO = securityRuleDAO;
    }

    /**
     * {@inheritDoc}
     */
    public List<SecurityRule> findAll()
    {
        return securityRuleDAO.findAll();
    }

    /**
     * {@inheritDoc}
     */
    public List<SecurityRule> findFiltered(SecurityRule filter)
    {
        return securityRuleDAO.findFiltered(filter);
    }

    /**
     * {@inheritDoc}
     */
    public Filter getEntityFilterFromRules(String entity, List<SecurityRule> rules) throws SecurityException,
        ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException
    {
        // @todo: check rules consistency with the gentity
        return new JavaBeanFilter(entity, rules);
    }

    /**
     * {@inheritDoc}
     */
    public SecurityRule load(Long id)
    {
        return securityRuleDAO.load(id);
    }

    /**
     * {@inheritDoc}
     */
    public SecurityRule loadIfAvailable(Long id)
    {
        return securityRuleDAO.loadIfAvailable(id);
    }

    /**
     * {@inheritDoc}
     */
    public boolean delete(Long id)
    {
        return securityRuleDAO.delete(id);
    }

    /**
     * {@inheritDoc}
     */
    public Long save(SecurityRule securityRule)
    {
        return securityRuleDAO.save(securityRule);
    }

    /**
     * {@inheritDoc}
     */
    public void saveOrUpdate(SecurityRule securityRule)
    {
        securityRuleDAO.saveOrUpdate(securityRule);
    }

    /**
     * {@inheritDoc}
     */
    public void update(SecurityRule securityRule)
    {
        securityRuleDAO.update(securityRule);
    }

    /**
     * {@inheritDoc}
     */
    public List<SecurityRule> getRulesForRoles(String entity, List<String> roles)
    {
        List<SecurityRule> rules = new ArrayList<SecurityRule>();
        for (String role : roles)
        {
            SecurityRule filter = new SecurityRule();
            filter.setEntity(entity);
            filter.setRole(role);
            rules.addAll(findFiltered(filter));
        }
        return rules;
    }
}
