/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.hibernate.security.aop;

import it.openutils.hibernate.security.dataobject.SecurityRule;
import it.openutils.hibernate.security.services.SecurityRuleManager;
import java.util.ArrayList;
import java.util.List;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.context.SecurityContextHolder;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.hibernate.Filter;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Aspect
public class AOPSecurity {
    private Logger log = LoggerFactory.getLogger(AOPSecurity.class);
    private SecurityRuleManager securityRuleManager;
    private List<String> securedDAOs;
    private boolean enabled;

    @Around(value="execution(* it.openutils.dao.hibernate.*.*(Object, .., java.util.List<org.hibernate.criterion.Criterion>)) &&  args(filter, .., additionalCriteria)")
    public Object applySecurityRules(ProceedingJoinPoint pjp, Object filter, List<Criterion> additionalCriteria) throws Throwable {
        if (!this.enabled) {
            this.log.debug("DAO security disabled, proceeding.");
            return pjp.proceed();
        }
        if (!this.securedDAOs.contains(pjp.getTarget().getClass().getCanonicalName())) {
            this.log.debug("The intercepted DAO {} is not secured, proceeding.", (Object)pjp.getTarget().toString());
            return pjp.proceed();
        }
        this.log.debug("applying security rules for {} with criteria {}", (Object)filter.toString(), additionalCriteria);
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            throw new SecurityException("Authentication is not valid");
        }
        GrantedAuthority[] authorities = authentication.getAuthorities();
        ArrayList<String> roles = new ArrayList<String>();
        for (int i = 0; i < authorities.length; ++i) {
            roles.add(authorities[i].getAuthority());
        }
        String entity = filter.getClass().getCanonicalName();
        List<SecurityRule> rules = this.securityRuleManager.getRulesForRoles(entity, roles);
        if (rules.isEmpty()) {
            String grantedRoles = "";
            for (int i = 0; i < authorities.length; ++i) {
                grantedRoles = grantedRoles + authorities[i].getAuthority() + " ";
            }
            this.log.warn("Access is denied on " + entity + ", for user {} with roles {}", (Object)SecurityContextHolder.getContext().getAuthentication().getPrincipal().toString(), (Object)grantedRoles);
            throw new SecurityException("Access denied");
        }
        Filter hibernateFilter = this.securityRuleManager.getEntityFilterFromRules(entity, rules);
        Criterion sqlCriterion = Restrictions.sqlRestriction((String)hibernateFilter.getFilterDefinition().getDefaultFilterCondition());
        this.log.debug("Adding sql restriction: {}", (Object)sqlCriterion.toString());
        additionalCriteria.add(sqlCriterion);
        Object result = pjp.proceed();
        return result;
    }

    public void setSecurityRuleManager(SecurityRuleManager securityRuleManager) {
        this.securityRuleManager = securityRuleManager;
    }

    public void setSecuredDAOs(List<String> securedDAOs) {
        this.securedDAOs = securedDAOs;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

