/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.hibernate.security.filter;

import it.openutils.hibernate.security.dataobject.SecurityRule;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Filter;
import org.hibernate.HibernateException;
import org.hibernate.annotations.Table;
import org.hibernate.engine.FilterDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaBeanFilter
implements Filter {
    private FilterDefinition filterDefinition;

    public JavaBeanFilter(String bean, List<SecurityRule> securityRules) throws ClassNotFoundException, InstantiationException, IllegalAccessException, SecurityException, NoSuchFieldException {
        Class<?> beanClass = Class.forName(bean, true, this.getClass().getClassLoader());
        if (!beanClass.isAnnotationPresent(Entity.class)) {
            throw new IllegalArgumentException();
        }
        if (!beanClass.isAnnotationPresent(javax.persistence.Table.class) && !beanClass.isAnnotationPresent(Table.class)) {
            throw new IllegalArgumentException();
        }
        HashMap<String, String> propertyColumnMap = new HashMap<String, String>();
        String filterDefCondition = "";
        String filterName = "";
        LinkedHashMap roleRuleMap = new LinkedHashMap();
        for (SecurityRule securityRule : securityRules) {
            if (!roleRuleMap.containsKey(securityRule.getRole())) {
                roleRuleMap.put(securityRule.getRole(), new ArrayList());
            }
            ((List)roleRuleMap.get(securityRule.getRole())).add(securityRule);
        }
        for (Map.Entry entry : roleRuleMap.entrySet()) {
            filterName = filterName + (String)entry.getKey();
            List rules = (List)entry.getValue();
            if (!StringUtils.isEmpty((String)filterDefCondition)) {
                filterDefCondition = filterDefCondition + " OR ";
            }
            filterDefCondition = filterDefCondition + "(";
            String subFilterCond = "";
            for (SecurityRule securityRule : rules) {
                String property = securityRule.getProperty();
                filterName = filterName + property;
                Field field = beanClass.getDeclaredField(property);
                propertyColumnMap.put(property, field.getAnnotation(Column.class).name());
                if (!StringUtils.isEmpty((String)subFilterCond)) {
                    subFilterCond = subFilterCond + " AND ";
                }
                String modifier = null;
                String startQuote = null;
                String endQuote = null;
                switch (securityRule.getModifier()) {
                    case EQUALS: {
                        modifier = " = ";
                        endQuote = startQuote = "'";
                        break;
                    }
                    case NOT: {
                        modifier = " != ";
                        endQuote = startQuote = "'";
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Modifier " + (Object)((Object)securityRule.getModifier()) + "not recognized");
                    }
                }
                subFilterCond = subFilterCond + field.getAnnotation(Column.class).name() + modifier + startQuote + securityRule.getValue() + endQuote;
                filterName = filterName + securityRule.getValue();
            }
            filterDefCondition = filterDefCondition + subFilterCond;
            filterDefCondition = filterDefCondition + ")";
        }
        this.filterDefinition = new FilterDefinition(Integer.toString(filterName.hashCode()), filterDefCondition, new HashMap());
    }

    public FilterDefinition getFilterDefinition() {
        return this.filterDefinition;
    }

    public String getName() {
        return this.filterDefinition.getFilterName();
    }

    public Filter setParameter(String name, Object value) {
        return this;
    }

    public Filter setParameterList(String name, Collection values) {
        return this;
    }

    public Filter setParameterList(String name, Object[] values) {
        return this;
    }

    public void validate() throws HibernateException {
    }
}

