/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.hibernate.security.services.impl;

import it.openutils.hibernate.security.dao.SecurityRuleDAO;
import it.openutils.hibernate.security.dataobject.SecurityRule;
import it.openutils.hibernate.security.filter.JavaBeanFilter;
import it.openutils.hibernate.security.services.SecurityRuleManager;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityRuleManagerImpl
implements SecurityRuleManager {
    private Logger log = LoggerFactory.getLogger(SecurityRuleManagerImpl.class);
    private SecurityRuleDAO securityRuleDAO;

    public void setSecurityRuleDAO(SecurityRuleDAO securityRuleDAO) {
        this.securityRuleDAO = securityRuleDAO;
    }

    @Override
    public List<SecurityRule> findAll() {
        return this.securityRuleDAO.findAll();
    }

    @Override
    public List<SecurityRule> findFiltered(SecurityRule filter) {
        return this.securityRuleDAO.findFiltered(filter);
    }

    @Override
    public Filter getEntityFilterFromRules(String entity, List<SecurityRule> rules) throws SecurityException, ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException {
        return new JavaBeanFilter(entity, rules);
    }

    @Override
    public SecurityRule load(Long id) {
        return (SecurityRule)this.securityRuleDAO.load(id);
    }

    @Override
    public SecurityRule loadIfAvailable(Long id) {
        return (SecurityRule)this.securityRuleDAO.loadIfAvailable(id);
    }

    @Override
    public boolean delete(Long id) {
        return this.securityRuleDAO.delete(id);
    }

    @Override
    public Long save(SecurityRule securityRule) {
        return (Long)this.securityRuleDAO.save(securityRule);
    }

    @Override
    public void saveOrUpdate(SecurityRule securityRule) {
        this.securityRuleDAO.saveOrUpdate(securityRule);
    }

    @Override
    public void update(SecurityRule securityRule) {
        this.securityRuleDAO.update(securityRule);
    }

    @Override
    public List<SecurityRule> getRulesForRoles(String entity, List<String> roles) {
        ArrayList<SecurityRule> rules = new ArrayList<SecurityRule>();
        for (String role : roles) {
            SecurityRule filter = new SecurityRule();
            filter.setEntity(entity);
            filter.setRole(role);
            rules.addAll(this.findFiltered(filter));
        }
        return rules;
    }
}

