/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.hibernate.security.filter;

import it.openutils.hibernate.security.dataobject.SecurityRule;
import it.openutils.hibernate.security.filter.utils.SecurityRuleUtils;
import it.openutils.hibernate.security.services.SecurityRuleManager;
import java.util.List;
import org.acegisecurity.Authentication;
import org.acegisecurity.ConfigAttributeDefinition;
import org.apache.commons.collections.Predicate;

public class SecurityRulePredicate
implements Predicate {
    private Authentication authentication;
    private SecurityRuleManager securityRuleManager;
    private ConfigAttributeDefinition configAttribute;
    private SecurityRuleUtils ruleUtils = new SecurityRuleUtils();

    public SecurityRulePredicate(Authentication authentication, ConfigAttributeDefinition configAttribute, SecurityRuleManager securityRuleManager) {
        this.authentication = authentication;
        this.securityRuleManager = securityRuleManager;
        this.configAttribute = configAttribute;
    }

    public boolean evaluate(Object object) {
        List<String> roles = this.ruleUtils.getRolesFromAuthentication(this.authentication);
        List<SecurityRule> rules = this.securityRuleManager.getRulesForRoles(this.ruleUtils.getClassName(object), roles);
        if (rules == null || rules.isEmpty()) {
            return false;
        }
        return this.ruleUtils.checkPermissions(rules, this.configAttribute) && this.ruleUtils.checkRules(rules, object);
    }
}

