/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.hibernate.security.filter;

import it.openutils.hibernate.security.filter.SecurityRuleBaseHandler;
import it.openutils.hibernate.security.filter.SecurityRulePredicate;
import it.openutils.hibernate.security.services.SecurityRuleManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.acegisecurity.AccessDeniedException;
import org.acegisecurity.Authentication;
import org.acegisecurity.ConfigAttributeDefinition;
import org.acegisecurity.afterinvocation.AfterInvocationProvider;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

public class SecurityRuleAfterInvocationHandler
extends SecurityRuleBaseHandler
implements AfterInvocationProvider {
    private SecurityRuleManager securityRuleManager;

    public Object decide(Authentication authentication, Object object, ConfigAttributeDefinition config, Object returnedObject) throws AccessDeniedException {
        if (returnedObject == null) {
            return null;
        }
        SecurityRulePredicate predicate = new SecurityRulePredicate(authentication, config, this.securityRuleManager);
        if (returnedObject instanceof Collection) {
            CollectionUtils.filter((Collection)((Collection)returnedObject), (Predicate)predicate);
        } else if (returnedObject.getClass().isArray()) {
            Object[] objectArray = (Object[])returnedObject;
            List<Object> objectArrayList = Arrays.asList(objectArray);
            CollectionUtils.filter(objectArrayList, (Predicate)predicate);
        } else if (!predicate.evaluate(returnedObject)) {
            throw new AccessDeniedException("Access denied");
        }
        return returnedObject;
    }

    public void setSecurityRuleManager(SecurityRuleManager securityRuleManager) {
        this.securityRuleManager = securityRuleManager;
    }
}

