/*
 * Copyright (c) Openmind.  All rights reserved. http://www.openmindonline.it
 */
package it.openutils.hibernate.security.dataobject;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Table;

import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.apache.commons.lang.builder.ToStringBuilder;


/**
 * @author fcarone
 * @version $Id: SecurityRule.java 698 2008-02-25 14:08:00Z fcarone $ A security rule
 */
@Entity
@Table(name = "SECURITY_RULE")
@FilterDefs({@FilterDef(name = "notDeletedRules", defaultCondition = "DELETED != '1'") })
@Filters({@Filter(name = "notDeletedRules") })
public class SecurityRule implements Serializable
{

    /**
     * Generated serial version UID
     */
    private static final long serialVersionUID = -4820683448073404349L;

    @Id
    @GeneratedValue(strategy = GenerationType.AUTO)
    @Column(name = "ID_SECURITY_RULE")
    private Long id;

    @Column(name = "ROLE", length = 64, nullable = false)
    private String role;

    @Column(name = "ENTITY", length = 512, nullable = false)
    private String entity;

    @Column(name = "PROPERTY", length = 512, nullable = false)
    private String property;

    @Column(name = "VALUE", nullable = false)
    private String value;

    @Enumerated(EnumType.STRING)
    @Column(name = "MODIFIER", nullable = false)
    private ModifierEnum modifier;

    @CollectionOfElements(fetch = FetchType.EAGER)
    @JoinTable(name = "SECRULE_PERMISSION", joinColumns = {@JoinColumn(name = "ID_SECURITY_RULE") })
    @Column(name = "PERMISSION", nullable = false)
    @Enumerated(EnumType.STRING)
    @Fetch(FetchMode.SUBSELECT)
    private List<PermissionEnum> permissions;

    @Enumerated(EnumType.STRING)
    @Column(name = "STATUS", nullable = false)
    private StatusEnum status;

    @Column(name = "DELETED", length = 1, nullable = false)
    private Boolean deleted;

    @CollectionOfElements(fetch = FetchType.EAGER)
    @org.hibernate.annotations.MapKey(columns = @Column(name = "NAME"))
    @JoinTable(name = "SECRULE_ENTITY", joinColumns = {@JoinColumn(name = "ID_SECURITY_RULE") })
    @Column(name = "VALUE", length = 256)
    @Fetch(FetchMode.SUBSELECT)
    private Map<String, String> entities;

    /**
     * Returns the role.
     * @return the role
     */
    public String getRole()
    {
        return role;
    }

    /**
     * Sets the role.
     * @param role the role to set
     */
    public void setRole(String role)
    {
        this.role = role;
    }

    /**
     * Returns the entity.
     * @return the entity
     */
    public String getEntity()
    {
        return entity;
    }

    /**
     * Sets the entity.
     * @param entity the entity to set
     */
    public void setEntity(String entity)
    {
        this.entity = entity;
    }

    /**
     * Returns the property.
     * @return the property
     */
    public String getProperty()
    {
        return property;
    }

    /**
     * Sets the property.
     * @param property the property to set
     */
    public void setProperty(String property)
    {
        this.property = property;
    }

    /**
     * Returns the value.
     * @return the value
     */
    public String getValue()
    {
        return value;
    }

    /**
     * Sets the value.
     * @param value the value to set
     */
    public void setValue(String value)
    {
        this.value = value;
    }

    /**
     * Returns the modifier.
     * @return the modifier
     */
    public ModifierEnum getModifier()
    {
        return modifier;
    }

    /**
     * Sets the modifier.
     * @param modifier the modifier to set
     */
    public void setModifier(ModifierEnum modifier)
    {
        this.modifier = modifier;
    }

    /**
     * Returns the permissions.
     * @return the permissions
     */
    public List<PermissionEnum> getPermissions()
    {
        return permissions;
    }

    /**
     * Sets the permissions.
     * @param permissions the permissions to set
     */
    public void setPermissions(List<PermissionEnum> permissions)
    {
        this.permissions = permissions;
    }

    /**
     * Returns the id.
     * @return the id
     */
    public Long getId()
    {
        return id;
    }

    /**
     * Sets the id.
     * @param id the id to set
     */
    public void setId(Long id)
    {
        this.id = id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString()
    {
        return new ToStringBuilder(this)
            .append("id", this.id)
            .append("role", this.role)
            .append("entity", this.entity)
            .append("property", this.property)
            .append("value", this.value)
            .append("modifier", this.modifier)
            .append("permissions", this.permissions)
            .toString();
    }

    /**
     * Returns the status.
     * @return the status
     */
    public StatusEnum getStatus()
    {
        return status;
    }

    /**
     * Sets the status.
     * @param status the status to set
     */
    public void setStatus(StatusEnum status)
    {
        this.status = status;
    }

    /**
     * @return True if the rule is enabled
     */
    public boolean isEnabled()
    {
        if (status == null)
        {
            return false;
        }
        return status.equals(StatusEnum.ENABLED);
    }

    /**
     * Returns the entities.
     * @return the entities
     */
    public Map<String, String> getEntities()
    {
        return entities;
    }

    /**
     * Sets the entities.
     * @param entities the entities to set
     */
    public void setEntities(Map<String, String> entities)
    {
        this.entities = entities;
    }


    /**
     * Returns the deleted.
     * @return the deleted
     */
    public Boolean getDeleted()
    {
        return deleted;
    }


    /**
     * Sets the deleted.
     * @param deleted the deleted to set
     */
    public void setDeleted(Boolean deleted)
    {
        this.deleted = deleted;
    }

}
