/*
 * Copyright 2005 Fabrizio Giustina.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package it.openutils.testing.junit;

import junit.framework.TestCase;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;


/**
 * Base class for running spring-based tests.
 * @author fgiust
 * @version $Revision $ ($Author $)
 */
public abstract class SpringTestCase extends TestCase
{

    /**
     * Default Spring context initilization file used for tests.
     */
    private static final String DEFAULT_TEST_CONTEXT_FILE = "/spring-tests.xml";

    /**
     * Spring application context.
     */
    protected static ApplicationContext ctx;

    /**
     * logger. Not static so it can be reused in tests
     */
    protected Logger log = LoggerFactory.getLogger(getClass());

    /**
     * {@inheritDoc}
     */
    @Override
    protected void setUp() throws Exception
    {

        if (ctx == null)
        {
            // load Spring's BeanFactory
            String[] paths = {DEFAULT_TEST_CONTEXT_FILE};
            ctx = new ClassPathXmlApplicationContext(paths);
        }

    }

}