/*
 * Copyright Openmind http://www.openmindonline.it
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package it.openutils.testing.testng;

import it.openutils.testing.DbUnitTestContext;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.BeforeMethod;


/**
 * @author fgiust
 * @version $Id: AbstractDbUnitTestNGSpringContextTests.java 563 2008-01-27 11:19:08Z fgiust $
 */
public class AbstractDbUnitTestNGSpringContextTests extends AbstractTestNGSpringContextTests
{

    /**
     * Slf4j logger that can be reused in subclasses.
     */
    protected Logger log = LoggerFactory.getLogger(getClass());

    /**
     * DBUnit text context.
     */
    protected DbUnitTestContext dbUnitTestContext;

    /**
     * Setup the Database before running the test method.
     * @throws Exception Any exception.
     */
    @SuppressWarnings("unchecked")
    @BeforeMethod
    protected void setUpDbUnit() throws Exception
    {
        dbUnitTestContext = new DbUnitTestContext(this, applicationContext);
        dbUnitTestContext.setUpDbUnit();
    }

}
