/*
 * Copyright Openmind http://www.openmindonline.it
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package it.openutils.testing.testng;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;

import javax.sql.DataSource;

import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.DatabaseSequenceFilter;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.excel.XlsDataSet;
import org.dbunit.dataset.filter.AbstractTableFilter;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.filter.SequenceTableFilter;
import org.dbunit.dataset.xml.XmlDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.hibernate.SessionFactory;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;


/**
 * @author fgiust
 * @version $Id: DbUnitTestCase.java 525 2008-01-12 10:46:12Z fgiust $
 * @deprecated use {@link AbstractDbUnitTestNGSpringContextTests}
 */
@Test
@Deprecated
public class DbUnitTestCase extends SpringTestCase
{

    /**
     * name for the dataSource bean in Spring context.
     */
    private static final String DATASOURCE_BEAN_NAME = "dataSource";

    /**
     * Pattern for dbunit file loaded before a test. MessageFormat format with two placeholders: class name and
     * extension.
     */
    private static final String DATAFILE_PATTERN = "/{0}-load.{1}";

    protected static IDataSet truncateDataSet;

    /**
     * Hibernate session factory.
     */
    private SessionFactory sessionFactory;

    /**
     * Optional schema (needed for ORACLE).
     * @return <code>null</code>
     */
    protected String getSchema()
    {
        return null;
    }

    /**
     * Should use deferred close emulating the spring OpenSessionInView filter? Default is <code>true</code>
     * @return <code>true</code> if deferred close should be used
     */
    protected boolean mimicSessionFilter()
    {
        return true;
    }

    /**
     * Returns the table filter that will be used to exclude certain tables from sort/deletion. This may be overridden
     * by subclasses, and is needed when tables have circular references (not handled by dbunit DatabaseSequenceFilter)
     * @return an <code>ITableFilter</code>
     */
    protected ITableFilter getTableFilter()
    {
        return new AbstractTableFilter()
        {

            @Override
            public boolean isValidName(String tableName) throws DataSetException
            {
                // default excludes:
                // $ = oracle recycle bin tables
                // JBPM = jbpm tables, with circular references
                return !StringUtils.contains(tableName, "$") && !StringUtils.contains(tableName, "JBPM");
            }
        };
    }

    /**
     * Setup the Database before running the test method.
     * @throws Exception Any exception.
     */
    @SuppressWarnings("unchecked")
    @BeforeMethod
    protected void setUpDbUnit() throws Exception
    {
        // mimic the Spring OpenSessionInViewFilter
        if (mimicSessionFilter())
        {
            Map<String, SessionFactory> sfbeans = ctx.getBeansOfType(SessionFactory.class);
            if (sfbeans.isEmpty())
            {
                Assert.fail("No bean of type org.hibernate.SessionFactory found in spring context");
            }
            this.sessionFactory = sfbeans.get(sfbeans.keySet().iterator().next());

            TransactionSynchronizationManager.bindResource(this.sessionFactory, new SessionHolder(this.sessionFactory
                .openSession()));
        }

        // check for xml
        IDataSet dataSet = loadDataSet(getDataFileName("xml"));

        if (dataSet == null)
        {
            // check for excel
            dataSet = loadDataSet(getDataFileName("xls"));
        }

        if (dataSet != null)
        {
            importDataSet(dataSet);
        }
        else
        {
            log.debug("No test data found with name [{}]", getDataFileName("xml/xls"));
        }
    }

    /**
     * Exports a database to an Excel file
     * @param fileName The file name we save the Excel dump to.
     * @throws IOException An IO Exception.
     * @throws DataSetException A dataset exception.
     * @throws SQLException A SQL Exception.
     */
    protected void exportDbToXls(String fileName) throws IOException, DataSetException, SQLException
    {
        IDatabaseConnection connection = getDbUnitConnection();

        IDataSet fullDataSet = connection.createDataSet();

        File outFile = new File(fileName);
        OutputStream fos = new FileOutputStream(outFile);
        XlsDataSet.write(fullDataSet, fos);
        fos.close();
    }

    /**
     * Cleans the database after we run the tests.
     * @throws Exception Any exception.
     */
    @AfterMethod
    protected void tearDownDbUnit() throws Exception
    {
        if (mimicSessionFilter())
        {
            // close open hibernate sessions, mimic the OpenSessionInViewFilter
            // close open hibernate sessions, mimic the OpenSessionInViewFilter
            if (TransactionSynchronizationManager.hasResource(this.sessionFactory))
            {
                TransactionSynchronizationManager.unbindResource(this.sessionFactory);
            }
        }

        // regenerate db initial state
        String datesetFileName = "/initial-load.xml";
        InputStream testData = getClass().getResourceAsStream(datesetFileName);

        if (testData != null)
        {
            log.debug("Restoring db state");

            IDataSet dataSet = new XmlDataSet(testData);

            IDatabaseConnection connection = getDbUnitConnection();

            try
            {
                DatabaseOperation.CLEAN_INSERT.execute(connection, dataSet);
            }
            finally
            {
                connection.close();
            }
        }
    }

    private void importDataSet(IDataSet dataSet) throws SQLException, DataSetException, DatabaseUnitException
    {
        IDatabaseConnection connection = getDbUnitConnection();

        if (truncateDataSet == null)
        {
            log.debug("Generating sorted dataset for initial cleanup");
            IDataSet unsortedTruncateDataSet = connection.createDataSet();

            ITableFilter filter = new DatabaseSequenceFilter(connection, new FilteredDataSet(
                getTableFilter(),
                unsortedTruncateDataSet).getTableNames());
            truncateDataSet = new FilteredDataSet(filter, unsortedTruncateDataSet);
            truncateDataSet = new FilteredDataSet(getTableFilter(), truncateDataSet);
            log.debug("Sorted dataset generated");
        }

        IDataSet orderedDataset = new FilteredDataSet(new AbstractTableFilter()
        {

            @Override
            public boolean isValidName(String tableName) throws DataSetException
            {
                return !StringUtils.contains(tableName, "$");
            }
        }, dataSet);

        log.debug("Tables: {}", ArrayUtils.toString(orderedDataset.getTableNames()));
        log.debug("Tables truncateDataSet: {}", ArrayUtils.toString(truncateDataSet.getTableNames()));

        // if a sorted dataset is available, use table sequence for sorting
        if (truncateDataSet != null)
        {
            ITableFilter filter = new SequenceTableFilter(truncateDataSet.getTableNames());
            orderedDataset = new FilteredDataSet(filter, dataSet);
        }

        try
        {

            if (truncateDataSet != null)
            {
                DatabaseOperation.DELETE_ALL.execute(connection, truncateDataSet);
            }
            if (dataSet != null)
            {
                DatabaseOperation.INSERT.execute(connection, orderedDataset);
            }
        }
        finally
        {
            connection.close();
        }
    }

    /**
     * @return
     * @throws SQLException
     */
    private IDatabaseConnection getDbUnitConnection() throws SQLException
    {
        DataSource dataSource = (DataSource) ctx.getBean(DATASOURCE_BEAN_NAME);
        IDatabaseConnection connection = new DatabaseConnection(dataSource.getConnection(), getSchema());
        return connection;
    }

    private String getDataFileName(String extension)
    {
        return MessageFormat.format(DATAFILE_PATTERN, ClassUtils.getShortClassName(getClass()), extension);
    }

    private IDataSet loadDataSet(String datesetFile) throws IOException, DataSetException
    {
        InputStream is = getClass().getResourceAsStream(datesetFile);
        IDataSet dataSet = null;

        if (is != null)
        {
            log.debug("loading dataset {}", datesetFile);
            dataSet = datesetFile.endsWith(".xls") ? new XlsDataSet(is) : new XmlDataSet(is);
            is.close();
        }

        return dataSet;
    }
}
