/*
 * Copyright Openmind http://www.openmindonline.it
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package it.openutils.testing.testng;

import java.lang.reflect.ParameterizedType;

import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;


/**
 * @param <D> Spring-managed bean under test. Warning, this base class expect that the name of the bean is the
 * non-qualified lowercase class name of the object. For example the bean name for
 * <code>org.something.MyNiceComponent</code> is expected to be <code>myNiceComponent</code>. The bean obtained
 * from Spring is made available through the <code>instance</code> protected field.
 * @author fgiust
 * @version $Id: GenericsDbUnitTestCase.java 525 2008-01-12 10:46:12Z fgiust $
 * @deprecated use {@link AbstractDbUnitTestNGSpringContextTests}
 */
@Test
@Deprecated
public class GenericsDbUnitTestCase<D> extends DbUnitTestCase
{

    /**
     * Test instance.
     */
    protected D instance;

    /**
     * Load the tested bean from Spring application context.
     */
    @SuppressWarnings("unchecked")
    @BeforeClass
    protected void setUp()
    {
        String genericClass = ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[0]
            .toString();

        instance = (D) ctx.getBean(StringUtils.uncapitalize(ClassUtils.getShortClassName(genericClass)));
    }
}
