/*
 * Copyright Openmind http://www.openmindonline.it
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package it.openutils.testing.testng;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;


/**
 * Base class for running spring-based tests.
 * @author fgiust
 * @version $Revision $ ($Author $)
 * @deprecated {@link org.springframework.test.context.testng.AbstractTestNGSpringContextTests}
 */
@Test
@Deprecated
public abstract class SpringTestCase
{

    /**
     * Default Spring context initilization file used for tests.
     */
    public static final String DEFAULT_TEST_CONTEXT_FILE = "/spring-tests.xml";

    /**
     * Spring application context.
     */
    protected static ApplicationContext ctx;

    /**
     * logger. Not static so it can be reused in tests
     */
    protected Logger log = LoggerFactory.getLogger(getClass());

    /**
     * Setup Spring application context, by loading the <code>/spring-tests.xml</code> file from the classpath.
     * @throws Exception
     */
    @BeforeClass
    protected void setUpSpring()
    {

        if (ctx == null)
        {
            // load Spring's BeanFactory
            String[] paths = {DEFAULT_TEST_CONTEXT_FILE };
            ctx = new ClassPathXmlApplicationContext(paths)
            {

                /**
                 * {@inheritDoc}
                 */
                @Override
                protected void initBeanDefinitionReader(XmlBeanDefinitionReader beanDefinitionReader)
                {
                    initAppContextBeanDefinitionReader(beanDefinitionReader);
                }
            };
        }
    }

    /**
     * You can override this method if you need to pass a custom documentReaderClass to the spring bean definition
     * reader.
     * @param beanDefinitionReader XmlBeanDefinitionReader instance
     */
    protected void initAppContextBeanDefinitionReader(XmlBeanDefinitionReader beanDefinitionReader)
    {
        // you can subclass this method if needed
    }

}