/*
 * Copyright Openmind http://www.openmindonline.it
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package it.openutils.testing.testng.utils;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import org.testng.Assert;


/**
 * Utility methods for checking dates in unit tests.
 * @author fgiust
 * @version $Id: DateAssert.java 525 2008-01-12 10:46:12Z fgiust $
 * @deprecated use {@link it.openutils.testing.DateAssert}
 */
@Deprecated
public final class DateAssert
{

    private static DateFormat df = new SimpleDateFormat("yyyyMMdd");

    private static DateFormat dtf = new SimpleDateFormat("yyyyMMdd HH:mm");

    /**
     * Don't instantiate.
     */
    private DateAssert()
    {
        // unused
    }

    /**
     * Asserts that two dates are equal.
     * @param expectedDateAsString date formatted as "YYYYMMDD"
     * @param date actual date
     * @throws IllegalArgumentException if <code>expectedDateAsString</code> is not a valid date format
     */
    public static void dateEqual(String expectedDateAsString, Calendar date) throws IllegalArgumentException
    {
        Date expected;

        try
        {
            expected = df.parse(expectedDateAsString);
        }
        catch (ParseException e)
        {
            throw new IllegalArgumentException("Unparseable date String: [" + expectedDateAsString + "]");
        }

        if (date == null)
        {
            throw new AssertionError("Date is null");
        }

        Assert.assertEquals(date.getTime(), expected);
    }

    /**
     * Asserts that two dates are equal.
     * @param expectedDateAsString date formatted as "yyyyMMdd HH:mm"
     * @param date actual date
     * @throws IllegalArgumentException if <code>expectedDateAsString</code> is not a valid date format
     */
    public static void dateTimeEqual(String expectedDateAsString, Date date) throws IllegalArgumentException
    {
        Date expected;

        try
        {
            expected = dtf.parse(expectedDateAsString);
        }
        catch (ParseException e)
        {
            throw new IllegalArgumentException("Unparseable date String: [" + expectedDateAsString + "]");
        }

        if (date == null)
        {
            throw new AssertionError("Date is null");
        }

        if (date.getTime() != expected.getTime())
        {
            throw new AssertionError("Expected <" + expected + ">, actual <" + date + ">");
        }
    }

    /**
     * Asserts that two dates are equal.
     * @param expectedDateAsString date formatted as "yyyyMMdd HH:mm"
     * @param date actual date
     * @throws IllegalArgumentException if <code>expectedDateAsString</code> is not a valid date format
     */
    public static void dateTimeEqual(String expectedDateAsString, Calendar date) throws IllegalArgumentException
    {
        dateTimeEqual(expectedDateAsString, date.getTime());
    }

}
