/*
 * Decompiled with CFR 0.152.
 */
package it.openutils.testing.testng;

import it.openutils.testing.testng.SpringTestCase;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.StringUtils;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.DatabaseSequenceFilter;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.FilteredDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.excel.XlsDataSet;
import org.dbunit.dataset.filter.AbstractTableFilter;
import org.dbunit.dataset.filter.ITableFilter;
import org.dbunit.dataset.filter.SequenceTableFilter;
import org.dbunit.dataset.xml.XmlDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.orm.hibernate3.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test
@Deprecated
public class DbUnitTestCase
extends SpringTestCase {
    private static final String DATASOURCE_BEAN_NAME = "dataSource";
    private static final String DATAFILE_PATTERN = "/{0}-load.{1}";
    protected static IDataSet truncateDataSet;
    private SessionFactory sessionFactory;

    protected String getSchema() {
        return null;
    }

    protected boolean mimicSessionFilter() {
        return true;
    }

    protected ITableFilter getTableFilter() {
        return new AbstractTableFilter(){

            public boolean isValidName(String tableName) throws DataSetException {
                return !StringUtils.contains((String)tableName, (String)"$") && !StringUtils.contains((String)tableName, (String)"JBPM");
            }
        };
    }

    @BeforeMethod
    protected void setUpDbUnit() throws Exception {
        IDataSet dataSet;
        if (this.mimicSessionFilter()) {
            Map sfbeans = ctx.getBeansOfType(SessionFactory.class);
            if (sfbeans.isEmpty()) {
                Assert.fail((String)"No bean of type org.hibernate.SessionFactory found in spring context");
            }
            this.sessionFactory = (SessionFactory)sfbeans.get(sfbeans.keySet().iterator().next());
            TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)new SessionHolder((Session)this.sessionFactory.openSession()));
        }
        if ((dataSet = this.loadDataSet(this.getDataFileName("xml"))) == null) {
            dataSet = this.loadDataSet(this.getDataFileName("xls"));
        }
        if (dataSet != null) {
            this.importDataSet(dataSet);
        } else {
            this.log.debug("No test data found with name [{}]", (Object)this.getDataFileName("xml/xls"));
        }
    }

    protected void exportDbToXls(String fileName) throws IOException, DataSetException, SQLException {
        IDatabaseConnection connection = this.getDbUnitConnection();
        IDataSet fullDataSet = connection.createDataSet();
        File outFile = new File(fileName);
        FileOutputStream fos = new FileOutputStream(outFile);
        XlsDataSet.write((IDataSet)fullDataSet, (OutputStream)fos);
        ((OutputStream)fos).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterMethod
    protected void tearDownDbUnit() throws Exception {
        if (this.mimicSessionFilter() && TransactionSynchronizationManager.hasResource((Object)this.sessionFactory)) {
            TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
        }
        String datesetFileName = "/initial-load.xml";
        InputStream testData = this.getClass().getResourceAsStream(datesetFileName);
        if (testData != null) {
            this.log.debug("Restoring db state");
            XmlDataSet dataSet = new XmlDataSet(testData);
            IDatabaseConnection connection = this.getDbUnitConnection();
            try {
                DatabaseOperation.CLEAN_INSERT.execute(connection, (IDataSet)dataSet);
            }
            finally {
                connection.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importDataSet(IDataSet dataSet) throws SQLException, DataSetException, DatabaseUnitException {
        DatabaseSequenceFilter filter;
        IDatabaseConnection connection = this.getDbUnitConnection();
        if (truncateDataSet == null) {
            this.log.debug("Generating sorted dataset for initial cleanup");
            IDataSet unsortedTruncateDataSet = connection.createDataSet();
            filter = new DatabaseSequenceFilter(connection, new FilteredDataSet(this.getTableFilter(), unsortedTruncateDataSet).getTableNames());
            truncateDataSet = new FilteredDataSet((ITableFilter)filter, unsortedTruncateDataSet);
            truncateDataSet = new FilteredDataSet(this.getTableFilter(), truncateDataSet);
            this.log.debug("Sorted dataset generated");
        }
        FilteredDataSet orderedDataset = new FilteredDataSet((ITableFilter)new AbstractTableFilter(){

            public boolean isValidName(String tableName) throws DataSetException {
                return !StringUtils.contains((String)tableName, (String)"$");
            }
        }, dataSet);
        this.log.debug("Tables: {}", (Object)ArrayUtils.toString((Object)orderedDataset.getTableNames()));
        this.log.debug("Tables truncateDataSet: {}", (Object)ArrayUtils.toString((Object)truncateDataSet.getTableNames()));
        if (truncateDataSet != null) {
            filter = new SequenceTableFilter(truncateDataSet.getTableNames());
            orderedDataset = new FilteredDataSet((ITableFilter)filter, dataSet);
        }
        try {
            if (truncateDataSet != null) {
                DatabaseOperation.DELETE_ALL.execute(connection, truncateDataSet);
            }
            if (dataSet != null) {
                DatabaseOperation.INSERT.execute(connection, (IDataSet)orderedDataset);
            }
        }
        finally {
            connection.close();
        }
    }

    private IDatabaseConnection getDbUnitConnection() throws SQLException {
        DataSource dataSource = (DataSource)ctx.getBean(DATASOURCE_BEAN_NAME);
        DatabaseConnection connection = new DatabaseConnection(dataSource.getConnection(), this.getSchema());
        return connection;
    }

    private String getDataFileName(String extension) {
        return MessageFormat.format(DATAFILE_PATTERN, ClassUtils.getShortClassName(this.getClass()), extension);
    }

    private IDataSet loadDataSet(String datesetFile) throws IOException, DataSetException {
        InputStream is = this.getClass().getResourceAsStream(datesetFile);
        XlsDataSet dataSet = null;
        if (is != null) {
            this.log.debug("loading dataset {}", (Object)datesetFile);
            dataSet = datesetFile.endsWith(".xls") ? new XlsDataSet(is) : new XmlDataSet(is);
            is.close();
        }
        return dataSet;
    }
}

