/**
 *
 * Openutils testing library (TestNG) (http://www.openmindlab.com/lab/products/testing.html)
 *
 * Copyright(C) 2005-2013, Openmind S.r.l. http://www.openmindonline.it
 *
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * You may obtain a copy of the License at
 *
 * http://www.gnu.org/licenses/lgpl-2.1.html
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

package it.openutils.testing.testng;

import it.openutils.testing.DbUnitTestContext;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.annotations.BeforeMethod;


/**
 * @author fgiust
 * @version $Id: AbstractDbUnitTestNGSpringContextTests.java 4170 2012-12-23 14:17:57Z fgiust $
 */
public class AbstractDbUnitTestNGSpringContextTests extends AbstractTestNGSpringContextTests
{

    /**
     * Slf4j logger that can be reused in subclasses.
     */
    protected Logger log = LoggerFactory.getLogger(getClass());

    /**
     * DBUnit text context.
     */
    protected DbUnitTestContext dbUnitTestContext;

    /**
     * Setup the Database before running the test method.
     * @throws Exception Any exception.
     */
    @BeforeMethod
    protected void setUpDbUnit() throws Exception
    {
        dbUnitTestContext = new DbUnitTestContext(this, applicationContext);
        dbUnitTestContext.setUpDbUnit();
    }

}
