/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.testing4web;

import com.meterware.httpunit.GetMethodWebRequest;
import com.meterware.httpunit.HttpUnitOptions;
import com.meterware.httpunit.WebRequest;
import com.meterware.httpunit.WebResponse;
import com.meterware.servletunit.ServletRunner;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Hashtable;
import net.sourceforge.openutils.testing4web.TestServletOptions;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseJspEmbeddedTest {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected ServletRunner runner;

    protected String getContext() {
        return "/context";
    }

    protected String getWebXmlPathInClasspath() {
        return "WEB-INF/web.xml";
    }

    protected String getJspUrl(String jsp) {
        return "http://localhost" + this.getContext() + "/jsps/" + jsp;
    }

    public void setUp() throws Exception {
        File webxmlFile = this.getWebXml();
        if (!webxmlFile.exists()) {
            throw new AssertionError((Object)("No " + this.getWebXmlPathInClasspath() + " found in classpath"));
        }
        HttpUnitOptions.setDefaultCharacterSet((String)"utf-8");
        System.setProperty("file.encoding", "utf-8");
        this.runner = new ServletRunner(webxmlFile, this.getContext());
        Hashtable<String, String> params = new Hashtable<String, String>();
        params.put("javaEncoding", "utf-8");
        params.put("development", "true");
        params.put("keepgenerated", "false");
        params.put("modificationTestInterval", "1000");
        params.put("engineOptionsClass", TestServletOptions.class.getName());
        this.runner.registerServlet("*.jsp", "org.apache.jasper.servlet.JspServlet", params);
        this.log.debug("ServletRunner setup OK");
    }

    protected File getWebXml() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        URL webXmlUrl = classLoader.getResource(this.getWebXmlPathInClasspath());
        String path = null;
        try {
            path = URLDecoder.decode(webXmlUrl.getFile(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        File webxmlFile = new File(path);
        return webxmlFile;
    }

    public void tearDown() {
        this.runner.shutDown();
    }

    protected void checkGetWithExpectedTxt(String jspname) throws Exception {
        GetMethodWebRequest request = new GetMethodWebRequest(this.getJspUrl(jspname));
        WebResponse response = this.runner.getResponse((WebRequest)request);
        if (this.log.isDebugEnabled()) {
            this.log.debug("RESPONSE: " + response.getText());
        }
        String responseText = response.getText();
        String expectedFileName = StringUtils.substringBeforeLast((String)jspname, (String)".") + ".txt";
        InputStream stream = this.getClass().getResourceAsStream("/jsps/" + expectedFileName);
        String expected = IOUtils.toString((InputStream)stream);
        IOUtils.closeQuietly((InputStream)stream);
        this.assertEquals(responseText, expected);
    }

    protected abstract void assertEquals(String var1, String var2);
}

