/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.openutils.testing4web;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.jasper.JasperException;
import org.apache.jasper.compiler.TldLocationsCache;
import org.apache.jasper.xmlparser.ParserUtils;
import org.apache.jasper.xmlparser.TreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestTldLocationsCache
extends TldLocationsCache {
    private boolean initialized;
    private Map<String, String[]> filemappings;
    private Logger log = LoggerFactory.getLogger(TestTldLocationsCache.class);
    private final ServletContext ctxt2;

    public TestTldLocationsCache(ServletContext ctxt) {
        super(ctxt);
        this.ctxt2 = ctxt;
    }

    public TestTldLocationsCache(ServletContext ctxt, boolean redeployMode) {
        super(ctxt, redeployMode);
        this.ctxt2 = ctxt;
    }

    public String[] getLocation(String uri) throws JasperException {
        String[] location;
        if (!this.initialized) {
            this.initFilesInClasspath();
        }
        if ((location = super.getLocation(uri)) != null) {
            return location;
        }
        return this.filemappings.get(uri);
    }

    private void initFilesInClasspath() {
        ClassLoader webappLoader;
        this.filemappings = new HashMap<String, String[]>();
        for (ClassLoader loader = webappLoader = Thread.currentThread().getContextClassLoader(); loader != null; loader = loader.getParent()) {
            if (!(loader instanceof URLClassLoader)) continue;
            URL[] urls = ((URLClassLoader)loader).getURLs();
            for (int i = 0; i < urls.length; ++i) {
                File file;
                URL url = urls[i];
                if (StringUtils.endsWithIgnoreCase((String)url.getFile(), (String)".jar") || !(file = new File(url.getFile())).isDirectory()) continue;
                this.log.debug("Processing {}", (Object)url.getFile());
                this.findTld(file);
            }
        }
    }

    private void findTld(File f) {
        File[] list;
        for (File file : list = f.listFiles()) {
            String uri;
            if (file.isDirectory()) {
                this.findTld(file);
                continue;
            }
            if (!StringUtils.endsWithIgnoreCase((String)file.getName(), (String)".tld") || (uri = this.getUriFromTld(file)) == null || this.filemappings.get(uri) != null) continue;
            String contextRoot = this.ctxt2.getRealPath("/");
            File filetomap = file;
            if (!StringUtils.startsWith((String)file.getAbsolutePath(), (String)contextRoot)) {
                File destination = new File(new File(contextRoot, "-tldsfromclasspath"), file.getName());
                try {
                    FileUtils.copyFile((File)file, (File)destination, (boolean)true);
                    filetomap = destination;
                }
                catch (IOException e) {
                    this.log.warn("Unable to copy tld " + file.getAbsolutePath() + " to " + destination.getAbsolutePath());
                }
            }
            String filepath = TestTldLocationsCache.getRelativePath(new File(contextRoot), filetomap);
            this.log.debug("Adding {} to cache with url {}", (Object)uri, (Object)filepath);
            this.filemappings.put(uri, new String[]{filepath, null});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUriFromTld(File file) {
        BufferedInputStream in;
        String resourcePath = file.getAbsolutePath();
        try {
            in = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            this.log.warn("File {} not found", (Object)file.getAbsolutePath());
            return null;
        }
        try {
            String body;
            TreeNode tld = new ParserUtils().parseXMLDocument(resourcePath, (InputStream)in);
            TreeNode uri = tld.findChild("uri");
            if (uri != null && (body = uri.getBody()) != null) {
                String string = body;
                return string;
            }
        }
        catch (JasperException e) {
            this.log.error("Error processing " + file.getAbsolutePath(), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        return null;
    }

    private static List getPathList(File f) {
        ArrayList<String> l = new ArrayList<String>();
        try {
            for (File r = f.getCanonicalFile(); r != null; r = r.getParentFile()) {
                l.add(r.getName());
            }
        }
        catch (IOException e) {
            l = null;
        }
        return l;
    }

    private static String matchPathLists(List r, List f) {
        int j;
        String s = "";
        int i = r.size() - 1;
        for (j = f.size() - 1; i >= 0 && j >= 0 && r.get(i).equals(f.get(j)); --i, --j) {
        }
        while (i >= 0) {
            s = s + ".." + File.separator;
            --i;
        }
        while (j >= 1) {
            s = s + f.get(j) + File.separator;
            --j;
        }
        s = s + f.get(j);
        return s;
    }

    public static String getRelativePath(File home, File f) {
        List homelist = TestTldLocationsCache.getPathList(home);
        List filelist = TestTldLocationsCache.getPathList(f);
        String s = TestTldLocationsCache.matchPathLists(homelist, filelist);
        return s;
    }
}

