package it.openutils.usermanagement.acegi;

import it.openutils.usermanagement.dao.GroupDAO;
import it.openutils.usermanagement.dao.UserDAO;

import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UserDetailsService;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataAccessException;


public class HibernateUserDetailsServiceImpl implements UserDetailsService
{

    private Logger log = LoggerFactory.getLogger(getClass());

    private UserDAO userDao;

    private GroupDAO groupDao;

    public void setUserDao(UserDAO userDao)
    {
        this.userDao = userDao;
    }

    public void setGroupDAO(GroupDAO groupDao)
    {
        this.groupDao = groupDao;
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException
    {

        log.debug("Login:: Loading User's Data");

        it.openutils.usermanagement.dataobjects.User filter = new it.openutils.usermanagement.dataobjects.User();
        filter.setId(username);
        it.openutils.usermanagement.dataobjects.User user = null;

        user = this.userDao.findFilteredFirst(filter);

        // mandatory: UserDetailsService can't return null
        if (user == null)
        {
            throw new UsernameNotFoundException("Username " + username + " not found");
        }

        log.debug("Groups: {}, Roles {}", user.getGroups(), user.getRoles());
        log.debug("Authorities: {}", ArrayUtils.toString(user.getAuthorities()));

        log.debug("Login:: Returning User to Acegi: {}", user);

        return user;
    }

}
