package it.openutils.usermanagement.manager;

/**
 * @author fgiust
 * @version $Id: UserManager.java 165 2007-02-01 14:11:57Z fcarone $
 */
public interface UserManager
{

    /**
     * @param userid Indicates the user whose password is to reset
     * @return The new random generated password
     */
    String resetPassword(String userid);

    /**
     * @param userid The user changing password
     * @param oldPassword The old password
     * @param newPassword The new password
     * @return True if the password has been successfully reset, false otherwise.
     */
    boolean changePassword(String userid, String oldPassword, String newPassword);
}
