package it.openutils.usermanagement.manager;

import it.openutils.usermanagement.dao.UserDAO;
import it.openutils.usermanagement.dataobjects.User;

import org.acegisecurity.providers.encoding.ShaPasswordEncoder;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;


/**
 * @author fgiust
 * @version $Id: UserManagerImpl.java 48 2006-07-26 09:35:14Z fgiust $
 */
public class UserManagerImpl implements UserManager
{

    /**
     * User DAO.
     */
    private UserDAO userDAO;

    private Logger log = LoggerFactory.getLogger(getClass());

    /**
     * Password encoder from acegi.
     */
    private ShaPasswordEncoder passwordEncoder;

    /**
     * Setter for <code>passwordEncoder</code>.
     * @param passwordEncoder The passwordEncoder to set.
     */
    public void setPasswordEncoder(ShaPasswordEncoder passwordEncoder)
    {
        this.passwordEncoder = passwordEncoder;
    }

    /**
     * Setter for <code>userDAO</code>.
     * @param userDAO The userDAO to set.
     */
    public void setUserDAO(UserDAO userDAO)
    {
        this.userDAO = userDAO;
    }

    /**
     * @see it.barilla.ika.manager.UserManager#resetPassword(java.lang.String)
     */

    public String resetPassword(String userid)
    {

        User resetUser = userDAO.load(userid);

        // cleartext password
        String plainPassword = StringUtils.upperCase(RandomStringUtils.randomAlphanumeric(6));

        String passwordHash = passwordEncoder.encodePassword(plainPassword, null);
        resetUser.setPassword(passwordHash);
        userDAO.update(resetUser);

        return plainPassword;
    }

    /**
     * @see it.barilla.ika.manager.UserManager#changePassword(java.lang.String, java.lang.String)
     */
    public boolean changePassword(String userid, String oldPassword, String newPassword)
    {

        String oldPasswordHash = passwordEncoder.encodePassword(oldPassword, null);
        User user = userDAO.load((userid));

        if (oldPasswordHash.equals(user.getPassword()))
        {

            String newPasswordHash = passwordEncoder.encodePassword(newPassword, null);
            user.setPassword(newPasswordHash);
            userDAO.save(user);
            return true;
        }
        else
        {
            return false;
        }

    }

}
